/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.minifi.toolkit.configuration.json;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import org.apache.nifi.controller.flow.VersionedDataflow;
import org.apache.nifi.flow.ScheduledState;
import org.apache.nifi.flow.VersionedProcessGroup;
import org.apache.nifi.flow.VersionedRemoteGroupPort;
import org.apache.nifi.flow.VersionedRemoteProcessGroup;
import org.apache.nifi.minifi.toolkit.configuration.ConfigMain;
import org.apache.nifi.minifi.toolkit.configuration.ConfigTransformException;
import org.apache.nifi.minifi.toolkit.configuration.PathInputStreamFactory;
import org.apache.nifi.minifi.toolkit.configuration.PathOutputStreamFactory;
import org.apache.nifi.minifi.toolkit.configuration.json.ObjectMapperUtils;
import org.apache.nifi.registry.flow.RegisteredFlowSnapshot;

public class TransformNifiCommandFactory {
    public static final String TRANSFORM_NIFI = "transform-nifi";
    private static final String COMMAND_DESCRIPTION = "Transform NiFi flow JSON format into MiNifi flow JSON format";
    private final PathInputStreamFactory pathInputStreamFactory;
    private final PathOutputStreamFactory pathOutputStreamFactory;

    public TransformNifiCommandFactory(PathInputStreamFactory pathInputStreamFactory, PathOutputStreamFactory pathOutputStreamFactory) {
        this.pathInputStreamFactory = pathInputStreamFactory;
        this.pathOutputStreamFactory = pathOutputStreamFactory;
    }

    public ConfigMain.Command create() {
        return new ConfigMain.Command(this::transformNifiToJson, COMMAND_DESCRIPTION);
    }

    private int transformNifiToJson(String[] args) {
        if (args.length != 3) {
            this.printTransformUsage();
            return 1;
        }
        String sourceNiFiJsonPath = args[1];
        String targetMiNiFiJsonPath = args[2];
        try {
            RegisteredFlowSnapshot registeredFlowSnapshot = this.readNifiFlow(sourceNiFiJsonPath);
            VersionedDataflow versionedDataflow = new VersionedDataflow();
            versionedDataflow.setRootGroup(registeredFlowSnapshot.getFlowContents());
            versionedDataflow.setParameterContexts(new ArrayList(registeredFlowSnapshot.getParameterContexts().values()));
            this.setDefaultValues(versionedDataflow);
            this.persistFlowJson(versionedDataflow, targetMiNiFiJsonPath);
        }
        catch (ConfigTransformException e) {
            System.out.println("Unable to convert NiFi JSON to MiNiFi flow JSON: " + String.valueOf(e));
            return e.getErrorCode();
        }
        return 0;
    }

    private void printTransformUsage() {
        System.out.println("transform Nifi Usage:");
        System.out.println();
        System.out.println(" transform-nifi SOURCE_NIFI_JSON_FLOW_FILE TARGET_MINIFI_JSON_FLOW_FILE");
        System.out.println();
    }

    private RegisteredFlowSnapshot readNifiFlow(String sourceNiFiJsonPath) throws ConfigTransformException {
        RegisteredFlowSnapshot registeredFlowSnapshot;
        block8: {
            InputStream inputStream = this.pathInputStreamFactory.create(sourceNiFiJsonPath);
            try {
                ObjectMapper objectMapper = ObjectMapperUtils.createObjectMapper();
                registeredFlowSnapshot = (RegisteredFlowSnapshot)objectMapper.readValue(inputStream, RegisteredFlowSnapshot.class);
                if (inputStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new ConfigTransformException("Error when reading NiFi flow json file", 3, e);
                }
            }
            inputStream.close();
        }
        return registeredFlowSnapshot;
    }

    private void persistFlowJson(VersionedDataflow flow, String flowJsonPath) throws ConfigTransformException {
        try (OutputStream outputStream = this.pathOutputStreamFactory.create(flowJsonPath);){
            ObjectMapper objectMapper = ObjectMapperUtils.createObjectMapper();
            objectMapper.writeValue(outputStream, (Object)flow);
        }
        catch (IOException e) {
            throw new ConfigTransformException("Error when persisting flow JSON file: " + flowJsonPath, 9, e);
        }
    }

    private void setDefaultValues(VersionedDataflow versionedDataflow) {
        versionedDataflow.setMaxTimerDrivenThreadCount(1);
        this.setDefaultValues(versionedDataflow.getRootGroup());
    }

    private void setDefaultValues(VersionedProcessGroup versionedProcessGroup) {
        versionedProcessGroup.getRemoteProcessGroups().forEach(this::setDefaultValues);
        versionedProcessGroup.getProcessGroups().forEach(this::setDefaultValues);
    }

    private void setDefaultValues(VersionedRemoteProcessGroup versionedRemoteProcessGroup) {
        versionedRemoteProcessGroup.getInputPorts().forEach(this::setDefaultValues);
    }

    private void setDefaultValues(VersionedRemoteGroupPort versionedRemoteGroupPort) {
        versionedRemoteGroupPort.setScheduledState(ScheduledState.RUNNING);
    }
}

