/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.remote.util;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import org.apache.commons.lang3.StringUtils;

public class ClusterUrlParser {
    public static Set<String> parseClusterUrls(String clusterUrls) {
        LinkedHashSet urls = new LinkedHashSet();
        if (clusterUrls != null && !clusterUrls.isEmpty()) {
            Arrays.stream(clusterUrls.split(",")).map(String::trim).filter(s -> !s.isEmpty()).forEach(s -> {
                ClusterUrlParser.validateUriString(s);
                urls.add(ClusterUrlParser.resolveBaseUrl(s).intern());
            });
        }
        if (urls.isEmpty()) {
            throw new IllegalArgumentException("Cluster URL was not specified.");
        }
        Predicate<String> isHttps = url -> url.toLowerCase().startsWith("https:");
        if (urls.stream().anyMatch(isHttps) && urls.stream().anyMatch(isHttps.negate())) {
            throw new IllegalArgumentException("Different protocols are used in the cluster URLs " + clusterUrls);
        }
        return Collections.unmodifiableSet(urls);
    }

    static String resolveBaseUrl(String clusterUrl) {
        URI uri;
        Objects.requireNonNull(clusterUrl, "clusterUrl cannot be null.");
        try {
            uri = new URI(clusterUrl.trim());
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("The specified URL is malformed: " + clusterUrl);
        }
        return ClusterUrlParser.resolveBaseUrl(uri);
    }

    private static void validateUriString(String s) {
        URI uri;
        try {
            uri = URI.create(s);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("The specified remote process group URL is malformed: " + s);
        }
        if (uri.getScheme() == null || uri.getHost() == null) {
            throw new IllegalArgumentException("The specified remote process group URL is malformed: " + s);
        }
        if (!uri.getScheme().equalsIgnoreCase("http") && !uri.getScheme().equalsIgnoreCase("https")) {
            throw new IllegalArgumentException("The specified remote process group URL is invalid because it is not http or https: " + s);
        }
    }

    private static String resolveBaseUrl(URI clusterUrl) {
        if (clusterUrl.getScheme() == null || clusterUrl.getHost() == null) {
            throw new IllegalArgumentException("The specified URL is malformed: " + String.valueOf(clusterUrl));
        }
        if (!clusterUrl.getScheme().equalsIgnoreCase("http") && !clusterUrl.getScheme().equalsIgnoreCase("https")) {
            throw new IllegalArgumentException("The specified URL is invalid because it is not http or https: " + String.valueOf(clusterUrl));
        }
        String uriPath = clusterUrl.getPath().trim();
        if (StringUtils.isEmpty((CharSequence)uriPath) || uriPath.equals("/")) {
            uriPath = "/nifi";
        } else if (uriPath.endsWith("/")) {
            uriPath = uriPath.substring(0, uriPath.length() - 1);
        }
        StringBuilder uriPathBuilder = new StringBuilder(uriPath);
        if (uriPath.endsWith("/nifi")) {
            uriPathBuilder.append("-api");
        } else if (!uriPath.endsWith("/nifi-api")) {
            uriPathBuilder.append("/nifi-api");
        }
        try {
            URI uri = new URI(clusterUrl.getScheme(), null, clusterUrl.getHost(), clusterUrl.getPort(), uriPathBuilder.toString(), null, null);
            return uri.toString();
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }
}

