/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util.security;

import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.List;
import java.util.ServiceLoader;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.security.CredentialProvider;
import org.eclipse.jetty.util.security.Password;
import org.eclipse.jetty.util.security.UnixCrypt;
import org.eclipse.jetty.util.thread.AutoLock;

public abstract class Credential
implements Serializable {
    private static final long serialVersionUID = -7760551052768181572L;
    private static final List<CredentialProvider> CREDENTIAL_PROVIDERS = ServiceLoader.load(CredentialProvider.class).stream().map(ServiceLoader.Provider::get).toList();

    public abstract boolean check(Object var1);

    public static Credential getCredential(String credential) {
        if (credential.startsWith("CRYPT:")) {
            return new Crypt(credential);
        }
        if (credential.startsWith("MD5:")) {
            return new MD5(credential);
        }
        if (credential.startsWith("MD:")) {
            return new MD(credential);
        }
        for (CredentialProvider cp : CREDENTIAL_PROVIDERS) {
            Credential credentialObj;
            if (!credential.startsWith(cp.getPrefix()) || (credentialObj = cp.getCredential(credential)) == null) continue;
            return credentialObj;
        }
        return new Password(credential);
    }

    protected static boolean stringEquals(String known, String unknown) {
        boolean sameObject;
        boolean bl = sameObject = known == unknown;
        if (sameObject) {
            return true;
        }
        if (known == null || unknown == null) {
            return false;
        }
        boolean result = true;
        int l1 = known.length();
        int l2 = unknown.length();
        for (int i = 0; i < l2; ++i) {
            result &= (l1 == 0 ? unknown.charAt(l2 - i - 1) : known.charAt(i % l1)) == unknown.charAt(i);
        }
        return result && l1 == l2;
    }

    protected static boolean byteEquals(byte[] known, byte[] unknown) {
        if (known == unknown) {
            return true;
        }
        if (known == null || unknown == null) {
            return false;
        }
        boolean result = true;
        int l1 = known.length;
        int l2 = unknown.length;
        for (int i = 0; i < l2; ++i) {
            result &= (l1 == 0 ? unknown[l2 - i - 1] : known[i % l1]) == unknown[i];
        }
        return result && l1 == l2;
    }

    public static class Crypt
    extends Credential {
        private static final long serialVersionUID = -2027792997664744210L;
        private static final String TYPE = "CRYPT:";
        private final String _cooked;

        private Crypt(String cooked) {
            this._cooked = cooked.startsWith(TYPE) ? cooked.substring(TYPE.length()) : cooked;
        }

        @Override
        public boolean check(Object credentials) {
            if (credentials instanceof char[]) {
                credentials = new String((char[])credentials);
            }
            return Crypt.stringEquals(this._cooked, UnixCrypt.crypt(credentials.toString(), this._cooked));
        }

        public int hashCode() {
            return this._cooked.hashCode();
        }

        public boolean equals(Object credential) {
            if (credential instanceof Crypt) {
                Crypt c = (Crypt)credential;
                return Crypt.stringEquals(this._cooked, c._cooked);
            }
            return false;
        }

        public static String crypt(String user, String pw) {
            return TYPE + UnixCrypt.crypt(pw, user);
        }
    }

    public static class MD5
    extends Credential {
        private static final long serialVersionUID = 5533846540822684240L;
        private static final String TYPE = "MD5:";
        private static final AutoLock __md5Lock = new AutoLock();
        private static MessageDigest __md;
        private final byte[] _digest;

        private MD5(String digest) {
            digest = digest.startsWith(TYPE) ? digest.substring(TYPE.length()) : digest;
            this._digest = StringUtil.fromHexString(digest);
        }

        public byte[] getDigest() {
            return this._digest;
        }

        @Override
        public boolean check(Object credentials) {
            try {
                if (credentials instanceof char[]) {
                    char[] chars = (char[])credentials;
                    credentials = new String(chars);
                } else if (credentials instanceof Password) {
                    Password password = (Password)credentials;
                    credentials = password.toString();
                }
                if (credentials instanceof String) {
                    String password = (String)credentials;
                    return MD5.byteEquals(this._digest, MD5.md5(password));
                }
                if (credentials instanceof MD5) {
                    return this.equals(credentials);
                }
                if (credentials instanceof Credential) {
                    Credential other = (Credential)credentials;
                    return other.check(this);
                }
                return false;
            }
            catch (Throwable x) {
                return false;
            }
        }

        public int hashCode() {
            return Arrays.hashCode(this._digest);
        }

        public boolean equals(Object obj) {
            if (obj instanceof MD5) {
                return MD5.byteEquals(this._digest, ((MD5)obj)._digest);
            }
            return false;
        }

        public static String digest(String password) {
            try {
                byte[] digest = MD5.md5(password);
                return TYPE + StringUtil.toHexString(digest);
            }
            catch (Throwable x) {
                return "<MD5 algorithm failure: %s>".formatted(x);
            }
        }

        private static byte[] md5(String password) throws NoSuchAlgorithmException {
            try (AutoLock ignored = __md5Lock.lock();){
                if (__md == null) {
                    __md = MessageDigest.getInstance("MD5");
                }
                __md.reset();
                byte[] byArray = __md.digest(password.getBytes(StandardCharsets.ISO_8859_1));
                return byArray;
            }
        }
    }

    public static class MD
    extends Credential {
        private static final long serialVersionUID = -4794312910062793449L;
        private static final String TYPE = "MD:";
        private final String _algorithm;
        private final byte[] _digest;

        private MD(String credential) {
            if (!credential.startsWith(TYPE)) {
                throw new IllegalArgumentException("Invalid credential " + credential);
            }
            String algoAndDigest = credential.substring(TYPE.length());
            int colon = algoAndDigest.indexOf(58);
            if (colon < 0) {
                throw new IllegalArgumentException("Invalid credential " + credential);
            }
            this._algorithm = algoAndDigest.substring(0, colon);
            this._digest = StringUtil.fromHexString(algoAndDigest.substring(colon + 1));
        }

        @Override
        public boolean check(Object credentials) {
            try {
                if (credentials instanceof char[]) {
                    char[] chars = (char[])credentials;
                    credentials = new String(chars);
                } else if (credentials instanceof byte[]) {
                    byte[] bytes = (byte[])credentials;
                    credentials = new String(bytes, StandardCharsets.UTF_8);
                } else if (credentials instanceof Password) {
                    Password password = (Password)credentials;
                    credentials = password.toString();
                }
                if (credentials instanceof String) {
                    String password = (String)credentials;
                    return MD.byteEquals(this._digest, MD.digest(this._algorithm, password));
                }
                if (credentials instanceof MD) {
                    return this.equals(credentials);
                }
                if (credentials instanceof Credential) {
                    Credential other = (Credential)credentials;
                    return other.check(this);
                }
                return false;
            }
            catch (Throwable x) {
                return false;
            }
        }

        public int hashCode() {
            return Arrays.hashCode(this._digest);
        }

        public boolean equals(Object obj) {
            if (obj instanceof MD) {
                MD other = (MD)obj;
                return MD.byteEquals(this._digest, other._digest);
            }
            return false;
        }

        static String format(String algorithm, String password) {
            try {
                byte[] bytes = MD.digest(algorithm, password);
                return TYPE + algorithm + ":" + StringUtil.toHexString(bytes);
            }
            catch (Throwable x) {
                return "<%s algorithm failure: %s>".formatted(algorithm, x);
            }
        }

        private static byte[] digest(String algorithm, String password) throws NoSuchAlgorithmException {
            MessageDigest digest = MessageDigest.getInstance(algorithm);
            return digest.digest(password.getBytes(StandardCharsets.UTF_8));
        }
    }
}

