/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.preflight.metadata;

import java.util.List;
import org.apache.pdfbox.preflight.exception.ValidationException;
import org.apache.xmpbox.XMPMetadata;
import org.apache.xmpbox.schema.XMPSchema;

public class RDFAboutAttributeConcordanceValidation {
    public void validateRDFAboutAttributes(XMPMetadata metadata) throws ValidationException, DifferentRDFAboutException {
        List<XMPSchema> schemas = metadata.getAllSchemas();
        if (schemas.isEmpty()) {
            throw new ValidationException("No schema found in the given metadata representation");
        }
        String about = schemas.get(0).getAboutValue();
        for (XMPSchema xmpSchema : schemas) {
            String schemaAboutValue = xmpSchema.getAboutValue();
            if (!("".equals(schemaAboutValue) || "".equals(about) || about.equals(schemaAboutValue))) {
                throw new DifferentRDFAboutException();
            }
            if (!"".equals(about)) continue;
            about = schemaAboutValue;
        }
    }

    public static class DifferentRDFAboutException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public DifferentRDFAboutException() {
            super("all rdf:about in RDF:rdf must have the same value");
        }
    }
}

