/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * license agreements; and to You under the Apache License, version 2.0:
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * This file is part of the Apache Pekko project, which was derived from Akka.
 */

/*
 * Copyright (C) 2018-2021 Lightbend Inc. <https://www.lightbend.com>
 */

package org.apache.pekko.grpc.internal

import java.util.concurrent.CompletionStage

import scala.concurrent.Future

import org.apache.pekko
import pekko.Done
import pekko.actor.ClassicActorSystemProvider
import pekko.annotation.{ InternalApi, InternalStableApi }
import pekko.event.LoggingAdapter
import pekko.grpc.{ GrpcChannel, GrpcClientSettings }

/**
 * INTERNAL API
 *
 * Deprecated: This class wraps a GrpcChannel for compatibility with clients generated by previous versions.
 */
@deprecated("Kept for binary compatibility between generated code and runtime", "akka-grpc 2.1.5")
@InternalApi
final class ClientState private (channel: GrpcChannel)(implicit sys: ClassicActorSystemProvider) {

  @InternalStableApi
  val internalChannel: InternalChannel =
    channel.internalChannel

  @InternalStableApi
  def this(settings: GrpcClientSettings, log: LoggingAdapter)(implicit sys: ClassicActorSystemProvider) =
    this(GrpcChannel(settings))

  def closedCS(): CompletionStage[Done] = channel.closedCS()
  def closeCS(): CompletionStage[Done] = channel.closeCS()

  def closed(): Future[Done] = channel.closed()

  def close(): Future[Done] = channel.close()
}

/**
 * INTERNAL API
 * Used from generated code so can't be private.
 *
 * Thrown if a withChannel call is called after closing the internal channel
 */
@InternalApi
final class ClientClosedException() extends RuntimeException("withChannel called after close()")
