/* ====================================================================
   Licensed to the Apache Software Foundation (ASF) under one or more
   contributor license agreements.  See the NOTICE file distributed with
   this work for additional information regarding copyright ownership.
   The ASF licenses this file to You under the Apache License, Version 2.0
   (the "License"); you may not use this file except in compliance with
   the License.  You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
==================================================================== */
package org.apache.poi.xdgf.usermodel.section;

import org.apache.poi.POIDataSamples;
import org.apache.poi.ooxml.TrackingInputStream;
import org.apache.poi.xdgf.usermodel.XmlVisioDocument;
import org.junit.jupiter.api.Test;

import java.io.IOException;

import static org.junit.jupiter.api.Assertions.assertFalse;
import static org.junit.jupiter.api.Assertions.assertTrue;

class TestXmlVisioDocument {

    private static final POIDataSamples SAMPLES = POIDataSamples.getDiagramInstance();

    @Test
    void testInputStreamClosed() throws IOException {
        try (TrackingInputStream stream = new TrackingInputStream(
                SAMPLES.openResourceAsStream("test_text_extraction.vsdx"))) {
            try (XmlVisioDocument xmlVisioDocument = new XmlVisioDocument(stream)) {
                assertFalse(xmlVisioDocument.getPages().isEmpty());
            }
            assertTrue(stream.isClosed(), "stream was closed?");
        }
    }

    @Test
    void testInputStreamNotClosedWhenOptionUsed() throws IOException {
        try (TrackingInputStream stream = new TrackingInputStream(
                SAMPLES.openResourceAsStream("test_text_extraction.vsdx"))) {
            try (XmlVisioDocument xmlVisioDocument = new XmlVisioDocument(stream, false)) {
                assertFalse(xmlVisioDocument.getPages().isEmpty());
            }
            assertFalse(stream.isClosed(), "stream was not closed?");
        }
    }

}
