/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.jms;

import jakarta.jms.IllegalStateException;
import jakarta.jms.JMSException;
import org.apache.qpid.jms.JmsSession;
import org.apache.qpid.jms.message.JmsInboundMessageDispatch;
import org.apache.qpid.jms.message.JmsMessageSupport;
import org.apache.qpid.jms.provider.ProviderConstants;

public final class JmsAcknowledgeCallback {
    private final JmsSession session;
    private final JmsInboundMessageDispatch envelope;
    private int ackType;

    public JmsAcknowledgeCallback(JmsSession session) {
        this(session, null);
    }

    public JmsAcknowledgeCallback(JmsSession session, JmsInboundMessageDispatch envelope) {
        this.session = session;
        this.envelope = envelope;
    }

    public void acknowledge() throws JMSException {
        if (this.session.isClosed()) {
            throw new IllegalStateException("Session closed.");
        }
        ProviderConstants.ACK_TYPE dispositionType = JmsMessageSupport.lookupAckTypeForDisposition(this.getAckType());
        if (this.envelope == null) {
            this.session.acknowledge(dispositionType);
        } else {
            this.session.acknowledgeIndividual(dispositionType, this.envelope);
        }
    }

    public boolean isAckTypeSet() {
        return this.ackType > 0;
    }

    public void clearAckType() {
        this.ackType = 0;
    }

    public int getAckType() {
        return this.ackType <= 0 ? 1 : this.ackType;
    }

    public void setAckType(int ackType) {
        this.ackType = ackType;
    }
}

