/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.protonj2.client;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;

public class SaslOptions
implements Cloneable {
    public static final boolean DEFAULT_SASL_ENABLED = true;
    private boolean saslEnabled = true;
    private final Set<String> saslAllowedMechs = new LinkedHashSet<String>();

    public SaslOptions clone() {
        return this.copyInto(new SaslOptions());
    }

    public boolean saslEnabled() {
        return this.saslEnabled;
    }

    public SaslOptions saslEnabled(boolean saslEnabled) {
        this.saslEnabled = saslEnabled;
        return this;
    }

    public SaslOptions addAllowedMechanism(String mechanism) {
        Objects.requireNonNull(mechanism, "Cannot add null as an allowed mechanism");
        this.saslAllowedMechs.add(mechanism);
        return this;
    }

    public Set<String> allowedMechanisms() {
        return Collections.unmodifiableSet(this.saslAllowedMechs);
    }

    public SaslOptions copyInto(SaslOptions other) {
        other.saslEnabled(this.saslEnabled());
        other.saslAllowedMechs.addAll(this.saslAllowedMechs);
        return other;
    }
}

