/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.remoting.serialization;

import com.alipay.remoting.exception.CodecException;
import com.alipay.remoting.serialization.Serializer;
import com.caucho.hessian.io.Hessian2Input;
import com.caucho.hessian.io.Hessian2Output;
import com.caucho.hessian.io.SerializerFactory;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class HessianSerializer
implements Serializer {
    private SerializerFactory serializerFactory = new SerializerFactory();

    @Override
    public byte[] serialize(Object obj) throws CodecException {
        ByteArrayOutputStream byteArray = new ByteArrayOutputStream();
        Hessian2Output output = new Hessian2Output((OutputStream)byteArray);
        output.setSerializerFactory(this.serializerFactory);
        try {
            output.writeObject(obj);
            output.close();
        }
        catch (IOException e) {
            throw new CodecException("IOException occurred when Hessian serializer encode!", e);
        }
        return byteArray.toByteArray();
    }

    @Override
    public <T> T deserialize(byte[] data, String classOfT) throws CodecException {
        Object resultObject;
        Hessian2Input input = new Hessian2Input((InputStream)new ByteArrayInputStream(data));
        input.setSerializerFactory(this.serializerFactory);
        try {
            resultObject = input.readObject();
            input.close();
        }
        catch (IOException e) {
            throw new CodecException("IOException occurred when Hessian serializer decode!", e);
        }
        return (T)resultObject;
    }
}

