/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.globis.phtree.v16hd.bst;

import ch.ethz.globis.phtree.v16hd.Node;
import ch.ethz.globis.phtree.v16hd.bst.BSTreePage;
import java.util.NoSuchElementException;

public class BSTIteratorAll {
    private BSTreePage currentPage;
    private int currentPos;
    private Node.BSTEntry nextValue;

    public BSTIteratorAll reset(BSTreePage root) {
        this.currentPage = root;
        this.currentPos = 0;
        if (this.findFirstLeafPage()) {
            this.findNext();
        }
        return this;
    }

    private boolean findFirstLeafPage() {
        while (!this.currentPage.isLeaf()) {
            if (this.currentPage.getNKeys() == -1) {
                this.currentPage = null;
                return false;
            }
            this.currentPage = this.currentPage.getPageByPos(0);
        }
        return true;
    }

    private void findNext() {
        if (this.currentPos >= this.currentPage.getNKeys()) {
            this.currentPage = this.currentPage.getNextLeaf();
            if (this.currentPage == null) {
                return;
            }
            this.currentPos = 0;
        }
        this.nextValue = this.currentPage.getValues()[this.currentPos];
        ++this.currentPos;
    }

    public boolean hasNextEntry() {
        return this.currentPage != null;
    }

    public Node.BSTEntry nextEntry() {
        if (!this.hasNextEntry()) {
            throw new NoSuchElementException();
        }
        Node.BSTEntry ret = this.nextValue;
        this.findNext();
        return ret;
    }
}

