/*
 * Decompiled with CFR 0.152.
 */
package org.twak.utils.ui.auto;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import org.twak.utils.Stringz;
import org.twak.utils.ui.AbstractDocumentListener;
import org.twak.utils.ui.ListDownLayout;
import org.twak.utils.ui.WindowManager;
import org.twak.utils.ui.auto.AutoRange;

public class Auto {
    Object o;
    protected JButton okay = new JButton("okay");
    JButton cancel = new JButton("cancel");
    JFrame frame;
    List<Apply> applies = new ArrayList<Apply>();
    boolean instant = false;

    public Auto(Object o, boolean instant) {
        this.o = o;
        this.instant = instant;
        this.build();
    }

    public JComponent build() {
        JPanel vals = new JPanel();
        vals.setLayout(new ListDownLayout());
        int pWidth = 100;
        for (Field f : this.o.getClass().getFields()) {
            JPanel entry = new JPanel(new GridLayout(1, 2));
            JComponent e = this.create(f);
            if (e == null) continue;
            this.applies.add((Apply)((Object)e));
            entry.add(new JLabel(this.getName(f)));
            entry.add(e);
            entry.setBorder(new EmptyBorder(3, 3, 3, 3));
            pWidth = Math.max(pWidth, entry.getPreferredSize().width + 5);
            vals.add(entry);
        }
        pWidth = Math.min(600, pWidth);
        JPanel okayCancel = new JPanel(new FlowLayout(4));
        this.okay.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (Auto.this.applies == null) {
                    return;
                }
                Auto.this.apply();
                Auto.this.applies = null;
            }
        });
        this.cancel.addActionListener(x -> this.done());
        this.updateOkayCancel();
        okayCancel.add(this.okay);
        okayCancel.add(this.cancel);
        vals.setPreferredSize(new Dimension(pWidth, vals.getPreferredSize().height));
        JPanel topLevel = new JPanel(new BorderLayout());
        JScrollPane scrollVals = new JScrollPane(vals);
        scrollVals.getVerticalScrollBar().setUnitIncrement(16);
        topLevel.add((Component)scrollVals, "Center");
        if (!this.instant) {
            topLevel.add((Component)okayCancel, "South");
        }
        return topLevel;
    }

    public void updateOkayCancel() {
        this.okay.setEnabled(this.applies.stream().mapToInt(a -> a.changed() ? 1 : 0).sum() > 0);
    }

    public void apply() {
        this.applies.stream().forEach(a -> a.apply());
        this.done();
    }

    public void done() {
        if (this.frame != null) {
            this.frame.setVisible(false);
            this.frame.dispose();
        }
    }

    private JComponent create(Field f) {
        if (f.getAnnotation(Ignore.class) != null) {
            return null;
        }
        try {
            Class<?> c = f.getType();
            if (c == Integer.TYPE) {
                return new AutoInteger(f);
            }
            if (c == Boolean.TYPE) {
                return new AutoBool(f);
            }
            if (c == Double.TYPE) {
                return new AutoDouble(f);
            }
            if (c == String.class) {
                return new AutoString(f);
            }
            if (Enum.class.isAssignableFrom(c)) {
                return new AutoEnum(f);
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        return null;
    }

    private String getName(Field f) {
        Name n = f.getAnnotation(Name.class);
        if (n == null) {
            return Stringz.splitCamelCase(f.getName()).toLowerCase();
        }
        String out = n.name();
        return out + ":";
    }

    public JFrame frame() {
        this.frame = new JFrame();
        WindowManager.register(this.frame);
        this.frame.setContentPane(this.build());
        this.frame.pack();
        this.frame.setSize(Math.min(800, this.frame.getWidth() + (Integer)UIManager.get("ScrollBar.width")), Math.min(600, this.frame.getHeight()));
        this.frame.setVisible(true);
        return this.frame;
    }

    private class AutoEnum
    extends JComboBox
    implements Apply {
        Enum<?> orig;
        Field f;

        public AutoEnum(Field f) throws IllegalArgumentException, IllegalAccessException {
            this.f = f;
            this.orig = (Enum)f.get(Auto.this.o);
            DefaultComboBoxModel<PrettyEnum> dcbm = new DefaultComboBoxModel<PrettyEnum>();
            PrettyEnum select = null;
            for (Enum e : (Enum[])this.orig.getClass().getEnumConstants()) {
                PrettyEnum tmp = new PrettyEnum(e);
                dcbm.addElement(tmp);
                if (this.orig != e) continue;
                select = tmp;
            }
            this.setModel(dcbm);
            this.setSelectedItem(select);
            this.addActionListener(l -> Auto.this.updateOkayCancel());
        }

        @Override
        public void apply() {
            try {
                this.f.set(Auto.this.o, ((PrettyEnum)this.getSelectedItem()).e);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }

        @Override
        public boolean changed() {
            try {
                return !((PrettyEnum)this.getSelectedItem()).e.equals(this.orig);
            }
            catch (Throwable e) {
                e.printStackTrace();
                return false;
            }
        }
    }

    private class PrettyEnum {
        Enum e;

        public PrettyEnum(Enum e) {
            this.e = e;
        }

        public String toString() {
            return this.e.toString().replaceAll("_", " ").toLowerCase();
        }
    }

    private class AutoString
    extends JTextField
    implements Apply {
        String orig;
        Field f;

        public AutoString(Field f) throws IllegalArgumentException, IllegalAccessException {
            super((String)f.get(Auto.this.o));
            this.f = f;
            this.orig = this.get();
            this.getDocument().addDocumentListener(new AbstractDocumentListener(){

                @Override
                public void changed() {
                    Auto.this.updateOkayCancel();
                }
            });
            if (this.orig == null) {
                this.setPreferredSize(new Dimension(100, this.getPreferredSize().height));
            }
        }

        @Override
        public void apply() {
            try {
                this.f.set(Auto.this.o, this.get());
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }

        @Override
        public boolean changed() {
            return this.get() != this.orig;
        }

        public String get() {
            String out = this.getText();
            if (out.length() == 0) {
                return null;
            }
            return out;
        }
    }

    private class AutoBool
    extends JCheckBox
    implements Apply {
        boolean orig;
        Field f;

        public AutoBool(Field f) throws IllegalArgumentException, IllegalAccessException {
            super("", f.getBoolean(Auto.this.o));
            this.f = f;
            this.orig = f.getBoolean(Auto.this.o);
            this.addChangeListener(c -> Auto.this.updateOkayCancel());
        }

        @Override
        public void apply() {
            try {
                this.f.setBoolean(Auto.this.o, this.isSelected());
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }

        @Override
        public boolean changed() {
            return this.isSelected() != this.orig;
        }
    }

    private class AutoDouble
    extends JSpinner
    implements Apply {
        double orig;
        Field f;

        public AutoDouble(Field f) throws IllegalArgumentException, IllegalAccessException {
            AutoRange[] ar = (AutoRange[])f.getAnnotationsByType(AutoRange.class);
            double min2 = -1.7976931348623157E308;
            double max = Double.MAX_VALUE;
            double step = 1.0;
            if (ar.length == 1) {
                min2 = ar[0].min();
                max = ar[0].max();
                step = ar[0].step();
            }
            this.setModel(new SpinnerNumberModel(f.getDouble(Auto.this.o), min2, max, step));
            this.f = f;
            this.orig = f.getDouble(Auto.this.o);
            this.addChangeListener(c -> Auto.this.updateOkayCancel());
        }

        @Override
        public void apply() {
            try {
                this.f.setDouble(Auto.this.o, (Double)this.getValue());
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }

        @Override
        public boolean changed() {
            return (Double)this.getValue() != this.orig;
        }
    }

    private class AutoInteger
    extends JSpinner
    implements Apply {
        String orig;
        Field f;

        public AutoInteger(Field f) throws IllegalArgumentException, IllegalAccessException {
            super(new SpinnerNumberModel(f.getInt(Auto.this.o), -2147483647, Integer.MAX_VALUE, 1));
            this.f = f;
            this.orig = this.getCurrentString();
            this.addChangeListener(c -> Auto.this.updateOkayCancel());
        }

        @Override
        public void apply() {
            try {
                this.f.setInt(Auto.this.o, (Integer)this.getValue());
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }

        @Override
        public boolean changed() {
            return !this.getCurrentString().equals(this.orig);
        }

        private String getCurrentString() {
            return ((JSpinner.DefaultEditor)this.getEditor()).getTextField().getText();
        }
    }

    private static interface Apply {
        public void apply();

        public boolean changed();
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface Ignore {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface Name {
        public String name();
    }
}

