/*
 * Decompiled with CFR 0.152.
 */
package com.mapzen.jpostal;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.Objects;

public final class Config {
    private static boolean libsLoaded = false;
    private final String dataDir;
    private final String libraryFile;
    private final Boolean downloadDataIfNeeded;
    private final Boolean senzing;

    private Config(String dataDir, String libraryFile, boolean downloadDataIfNeeded, boolean senzing) {
        this.dataDir = dataDir;
        this.libraryFile = libraryFile;
        this.downloadDataIfNeeded = downloadDataIfNeeded;
        this.senzing = senzing;
    }

    public String getDataDir() {
        return this.dataDir;
    }

    public String getLibraryFile() {
        return this.libraryFile;
    }

    public Boolean getDownloadDataIfNeeded() {
        return this.downloadDataIfNeeded;
    }

    public Boolean getSenzing() {
        return this.senzing;
    }

    void loadLibrary() {
        if (this.libraryFile != null) {
            System.load(this.libraryFile);
        } else {
            try {
                Config.loadLibsFromJar();
            }
            catch (UnsatisfiedLinkError ex) {
                System.loadLibrary("jpostal");
            }
        }
        libsLoaded = true;
    }

    static IllegalArgumentException mismatchException(Config current, Config requested) {
        return new IllegalArgumentException(String.format("Config mismatch: initialized instance uses [%s], but requested [%s]", current, requested));
    }

    public String toString() {
        return "Config{dataDir=" + this.dataDir + ",libraryFile=" + this.libraryFile + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Config)) {
            return false;
        }
        Config other = (Config)o;
        return Objects.equals(this.dataDir, other.dataDir) && Objects.equals(this.libraryFile, other.libraryFile);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static synchronized void loadLibraryFromJar(String libraryName) {
        String nativeLibArchName;
        String nativeLibFileName;
        String nativeLibOSName;
        if (libsLoaded) {
            return;
        }
        String osName = System.getProperty("os.name").toLowerCase();
        String osArch = System.getProperty("os.arch").toLowerCase();
        if (osName.contains("nix") || osName.contains("nux") || osName.contains("aix")) {
            nativeLibOSName = "linux";
            nativeLibFileName = "lib" + libraryName + ".so";
        } else if (osName.contains("freebsd")) {
            nativeLibOSName = "freebsd";
            nativeLibFileName = "lib" + libraryName + ".so";
        } else if (osName.contains("mac") || osName.contains("darwin")) {
            nativeLibOSName = "darwin";
            nativeLibFileName = "lib" + libraryName + ".dylib";
        } else if (osName.contains("win")) {
            nativeLibOSName = "windows";
            nativeLibFileName = libraryName + ".dll";
        } else {
            throw new UnsupportedOperationException("Unsupported OS: " + osName);
        }
        if (osArch.contains("arm64") || osArch.contains("aarch64")) {
            nativeLibArchName = "arm64";
        } else if (osArch.contains("x64") || osArch.contains("amd64") || osArch.contains("x86_64")) {
            nativeLibArchName = "x64";
        } else if (osArch.contains("32") || osArch.contains("86")) {
            nativeLibArchName = "x86";
        } else {
            throw new UnsupportedOperationException("Unsupported architecture: " + osArch);
        }
        String fullPathInJar = "/" + nativeLibOSName + "-" + nativeLibArchName + "/" + nativeLibFileName;
        try (InputStream in = Config.class.getResourceAsStream(fullPathInJar);){
            if (in == null) {
                throw new UnsatisfiedLinkError("Native library " + fullPathInJar + " not found in JAR");
            }
            File tempFile = File.createTempFile("lib", nativeLibFileName.substring(nativeLibFileName.lastIndexOf(46)));
            tempFile.deleteOnExit();
            Files.copy(in, tempFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
            System.load(tempFile.getAbsolutePath());
        }
        catch (IOException e) {
            throw new UnsatisfiedLinkError("Failed to load native library " + libraryName + ": " + e.getMessage());
        }
    }

    private static synchronized void loadLibsFromJar() {
        if (libsLoaded) {
            return;
        }
        Config.loadLibraryFromJar("postal");
        Config.loadLibraryFromJar("jpostal");
        libsLoaded = true;
    }

    public static class Builder {
        private String dataDir;
        private String libraryFile;
        private boolean downloadDataIfNeeded = false;
        private boolean senzing = false;

        private Builder() {
        }

        public Config build() {
            return new Config(this.dataDir, this.libraryFile, this.downloadDataIfNeeded, this.senzing);
        }

        public Builder dataDir(String dataDir) {
            this.dataDir = dataDir;
            return this;
        }

        public Builder libraryFile(String libraryFile) {
            this.libraryFile = libraryFile;
            return this;
        }

        public Builder downloadDataIfNeeded(boolean downloadDataIfNeeded) {
            this.downloadDataIfNeeded = downloadDataIfNeeded;
            return this;
        }

        public Builder senzing(boolean senzing) {
            this.senzing = senzing;
            return this;
        }
    }
}

