/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sedona.common.S2Geography;

import org.apache.sedona.shaded.s2.Projection;
import org.apache.sedona.shaded.s2.R2Vector;
import org.apache.sedona.shaded.s2.S2LatLng;
import org.apache.sedona.shaded.s2.S2Point;

public class Projection {
    public static Projection.PlateCarreeProjection lngLat() {
        return new Projection.PlateCarreeProjection(180.0);
    }

    public static Projection.MercatorProjection pseudoMercator() {
        double semiCircumference = 2.0037508342789244E7;
        return new Projection.MercatorProjection(semiCircumference);
    }

    public static class OrthographicProjection
    extends Projection {
        private S2LatLng centre;
        private S2Point zAxis = new S2Point(0.0, 0.0, 1.0);
        private S2Point yAxis = new S2Point(0.0, 1.0, 0.0);

        OrthographicProjection(S2LatLng centre) {
            this.zAxis = new S2Point(0.0, 0.0, 1.0);
            this.yAxis = new S2Point(0.0, 1.0, 0.0);
            this.centre = centre;
        }

        public R2Vector project(S2Point p) {
            S2Point out = S2Point.rotate(p, this.zAxis, -this.centre.lngRadians());
            if ((out = S2Point.rotate(out, this.yAxis, this.centre.latRadians())).getX() >= 0.0) {
                return new R2Vector(out.getY(), out.getZ());
            }
            return new R2Vector();
        }

        public S2Point unProject(R2Vector p) {
            double z;
            if (Double.isNaN(p.x()) || Double.isNaN(p.y())) {
                throw new IllegalArgumentException("Cannot unproject non-finite point in OrthographicProjection");
            }
            double y = p.x();
            double xy2 = y * y + (z = p.y()) * z;
            if (xy2 > 1.0) {
                throw new IllegalArgumentException("Point outside unit circle for orthographic");
            }
            double x = Math.sqrt(1.0 - xy2);
            S2Point out = new S2Point(x, y, z);
            out = S2Point.rotate(out, this.yAxis, -this.centre.latRadians());
            out = S2Point.rotate(out, this.zAxis, this.centre.lngRadians());
            return out;
        }

        public R2Vector fromLatLng(S2LatLng ll) {
            return this.project(ll.toPoint());
        }

        public S2LatLng toLatLng(R2Vector p) {
            return S2LatLng.fromPoint(this.unProject(p));
        }

        public S2Point wrapDistance() {
            return new S2Point(0.0, 0.0, 0.0);
        }
    }
}

