/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sedona.core.spatialPartitioning.quadtree;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang3.mutable.MutableInt;
import org.apache.sedona.common.utils.HalfOpenRectangle;
import org.apache.sedona.core.spatialPartitioning.PartitioningUtils;
import org.apache.sedona.core.spatialPartitioning.quadtree.QuadNode;
import org.apache.sedona.core.spatialPartitioning.quadtree.QuadRectangle;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Point;
import scala.Tuple2;

public class StandardQuadTree<T>
extends PartitioningUtils
implements Serializable {
    public static final int REGION_SELF = -1;
    public static final int REGION_NW = 0;
    public static final int REGION_NE = 1;
    public static final int REGION_SW = 2;
    public static final int REGION_SE = 3;
    private final int maxItemsPerZone;
    private final int maxLevel;
    private final int level;
    private final List<QuadNode<T>> nodes = new ArrayList<QuadNode<T>>();
    private final QuadRectangle zone;
    private int nodeNum = 0;
    private StandardQuadTree<T>[] regions;

    public StandardQuadTree(QuadRectangle definition, int level) {
        this(definition, level, 5, 10);
    }

    public StandardQuadTree(QuadRectangle definition, int level, int maxItemsPerZone, int maxLevel) {
        this.maxItemsPerZone = maxItemsPerZone;
        this.maxLevel = maxLevel;
        this.zone = definition;
        this.level = level;
    }

    public QuadRectangle getZone() {
        return this.zone;
    }

    private int findRegion(QuadRectangle r, boolean split) {
        int region = -1;
        if (this.nodeNum >= this.maxItemsPerZone && this.level < this.maxLevel) {
            if (this.regions == null && split) {
                this.split();
            }
            if (this.regions != null) {
                for (int i = 0; i < this.regions.length; ++i) {
                    if (!this.regions[i].getZone().contains(r)) continue;
                    region = i;
                    break;
                }
            }
        }
        return region;
    }

    private int findRegion(int x, int y) {
        int region = -1;
        if (this.regions != null) {
            for (int i = 0; i < this.regions.length; ++i) {
                if (!this.regions[i].getZone().contains(x, y)) continue;
                region = i;
                break;
            }
        }
        return region;
    }

    private StandardQuadTree<T> newQuadTree(QuadRectangle zone, int level) {
        return new StandardQuadTree<T>(zone, level, this.maxItemsPerZone, this.maxLevel);
    }

    private void split() {
        this.regions = new StandardQuadTree[4];
        double newWidth = this.zone.width / 2.0;
        double newHeight = this.zone.height / 2.0;
        int newLevel = this.level + 1;
        this.regions[0] = this.newQuadTree(new QuadRectangle(this.zone.x, this.zone.y + this.zone.height / 2.0, newWidth, newHeight), newLevel);
        this.regions[1] = this.newQuadTree(new QuadRectangle(this.zone.x + this.zone.width / 2.0, this.zone.y + this.zone.height / 2.0, newWidth, newHeight), newLevel);
        this.regions[2] = this.newQuadTree(new QuadRectangle(this.zone.x, this.zone.y, newWidth, newHeight), newLevel);
        this.regions[3] = this.newQuadTree(new QuadRectangle(this.zone.x + this.zone.width / 2.0, this.zone.y, newWidth, newHeight), newLevel);
    }

    public void forceGrowUp(int minLevel) {
        if (minLevel < 1) {
            throw new IllegalArgumentException("minLevel must be >= 1. Received " + minLevel);
        }
        this.split();
        this.nodeNum = this.maxItemsPerZone;
        if (this.level + 1 >= minLevel) {
            return;
        }
        for (StandardQuadTree<T> region : this.regions) {
            region.forceGrowUp(minLevel);
        }
    }

    public void insert(QuadRectangle r, T element) {
        int region = this.findRegion(r, true);
        if (region == -1 || this.level == this.maxLevel) {
            this.nodes.add(new QuadNode<T>(r, element));
            ++this.nodeNum;
            return;
        }
        this.regions[region].insert(r, element);
        if (this.nodeNum >= this.maxItemsPerZone && this.level < this.maxLevel) {
            ArrayList<QuadNode<T>> tempNodes = new ArrayList<QuadNode<T>>();
            tempNodes.addAll(this.nodes);
            this.nodes.clear();
            for (QuadNode quadNode : tempNodes) {
                this.insert(quadNode.r, quadNode.element);
            }
        }
    }

    public void dropElements() {
        this.traverse(new Visitor<T>(){

            @Override
            public boolean visit(StandardQuadTree<T> tree) {
                tree.nodes.clear();
                return true;
            }
        });
    }

    public List<T> getElements(QuadRectangle r) {
        int region = this.findRegion(r, false);
        ArrayList<T> list = new ArrayList<T>();
        if (region != -1) {
            for (QuadNode<T> node : this.nodes) {
                list.add(node.element);
            }
            list.addAll(this.regions[region].getElements(r));
        } else {
            this.addAllElements(list);
        }
        return list;
    }

    private void traverse(Visitor<T> visitor) {
        if (!visitor.visit(this)) {
            return;
        }
        if (this.regions != null) {
            this.regions[0].traverse(visitor);
            this.regions[1].traverse(visitor);
            this.regions[2].traverse(visitor);
            this.regions[3].traverse(visitor);
        }
    }

    private void traverseWithTrace(VisitorWithLineage<T> visitor, String lineage) {
        if (!visitor.visit(this, lineage)) {
            return;
        }
        if (this.regions != null) {
            this.regions[0].traverseWithTrace(visitor, lineage + "0");
            this.regions[1].traverseWithTrace(visitor, lineage + "1");
            this.regions[2].traverseWithTrace(visitor, lineage + "2");
            this.regions[3].traverseWithTrace(visitor, lineage + "3");
        }
    }

    private void addAllElements(final List<T> list) {
        this.traverse(new Visitor<T>(){

            @Override
            public boolean visit(StandardQuadTree<T> tree) {
                for (QuadNode node : tree.nodes) {
                    list.add(node.element);
                }
                return true;
            }
        });
    }

    public boolean isLeaf() {
        return this.regions == null;
    }

    public List<QuadRectangle> getAllZones() {
        final ArrayList<QuadRectangle> zones = new ArrayList<QuadRectangle>();
        this.traverse(new Visitor<T>(){

            @Override
            public boolean visit(StandardQuadTree<T> tree) {
                zones.add(tree.zone);
                return true;
            }
        });
        return zones;
    }

    public int getTotalNumLeafNode() {
        final MutableInt leafCount = new MutableInt(0);
        this.traverse(new Visitor<T>(){

            @Override
            public boolean visit(StandardQuadTree<T> tree) {
                if (tree.isLeaf()) {
                    leafCount.increment();
                }
                return true;
            }
        });
        return leafCount.getValue();
    }

    public QuadRectangle getZone(int x, int y) throws ArrayIndexOutOfBoundsException {
        int region = this.findRegion(x, y);
        if (region != -1) {
            return this.regions[region].getZone(x, y);
        }
        if (this.zone.contains(x, y)) {
            return this.zone;
        }
        throw new ArrayIndexOutOfBoundsException("[Sedona][StandardQuadTree] this pixel is out of the quad tree boundary.");
    }

    public QuadRectangle getParentZone(int x, int y, int minLevel) throws Exception {
        int region = this.findRegion(x, y);
        if (this.level < minLevel) {
            if (region == -1) {
                assert (this.regions == null);
                if (this.zone.contains(x, y)) {
                    throw new Exception("[Sedona][StandardQuadTree][getParentZone] this leaf node doesn't have enough depth. Please check ForceGrowUp. Expected: " + minLevel + " Actual: " + this.level + ". Query point: " + x + " " + y + ". Tree statistics, total leaf nodes: " + this.getTotalNumLeafNode());
                }
                throw new Exception("[Sedona][StandardQuadTree][getParentZone] this pixel is out of the quad tree boundary.");
            }
            return this.regions[region].getParentZone(x, y, minLevel);
        }
        if (this.zone.contains(x, y)) {
            return this.zone;
        }
        throw new Exception("[Sedona][StandardQuadTree][getParentZone] this pixel is out of the quad tree boundary.");
    }

    public List<QuadRectangle> findZones(QuadRectangle r) {
        final Envelope envelope = r.getEnvelope();
        final ArrayList<QuadRectangle> matches = new ArrayList<QuadRectangle>();
        this.traverse(new Visitor<T>(){

            @Override
            public boolean visit(StandardQuadTree<T> tree) {
                if (!StandardQuadTree.this.disjoint(tree.zone.getEnvelope(), envelope)) {
                    if (tree.isLeaf()) {
                        matches.add(tree.zone);
                    }
                    return true;
                }
                return false;
            }
        });
        return matches;
    }

    private boolean disjoint(Envelope r1, Envelope r2) {
        return !r1.intersects(r2) && !r1.covers(r2) && !r2.covers(r1);
    }

    public void assignPartitionIds() {
        this.traverse(new Visitor<T>(){
            private int partitionId = 0;

            @Override
            public boolean visit(StandardQuadTree<T> tree) {
                if (tree.isLeaf()) {
                    tree.getZone().partitionId = this.partitionId;
                    ++this.partitionId;
                }
                return true;
            }
        });
    }

    public void assignPartitionLineage() {
        this.traverseWithTrace(new VisitorWithLineage<T>(){

            @Override
            public boolean visit(StandardQuadTree<T> tree, String lineage) {
                if (tree.isLeaf()) {
                    tree.getZone().lineage = lineage;
                }
                return true;
            }
        }, "");
    }

    @Override
    public Iterator<Tuple2<Integer, Geometry>> placeObject(Geometry geometry) {
        Objects.requireNonNull(geometry, "spatialObject");
        Envelope envelope = geometry.getEnvelopeInternal();
        List<QuadRectangle> matchedPartitions = this.findZones(new QuadRectangle(envelope));
        Point point = geometry instanceof Point ? (Point)geometry : null;
        HashSet<Tuple2> result = new HashSet<Tuple2>();
        for (QuadRectangle rectangle : matchedPartitions) {
            if (point != null && !new HalfOpenRectangle(rectangle.getEnvelope()).contains(point)) continue;
            result.add(new Tuple2((Object)rectangle.partitionId, (Object)geometry));
        }
        return result.iterator();
    }

    @Override
    public Set<Integer> getKeys(Geometry geometry) {
        Objects.requireNonNull(geometry, "spatialObject");
        Envelope envelope = geometry.getEnvelopeInternal();
        List<QuadRectangle> matchedPartitions = this.findZones(new QuadRectangle(envelope));
        Point point = geometry instanceof Point ? (Point)geometry : null;
        HashSet<Integer> result = new HashSet<Integer>();
        for (QuadRectangle rectangle : matchedPartitions) {
            if (point != null && !new HalfOpenRectangle(rectangle.getEnvelope()).contains(point)) continue;
            result.add(rectangle.partitionId);
        }
        return result;
    }

    @Override
    public List<Envelope> fetchLeafZones() {
        final ArrayList<Envelope> leafZones = new ArrayList<Envelope>();
        this.traverse(new Visitor<T>(){

            @Override
            public boolean visit(StandardQuadTree<T> tree) {
                if (tree.isLeaf()) {
                    leafZones.add(tree.zone.getEnvelope());
                }
                return true;
            }
        });
        return leafZones;
    }

    private static interface VisitorWithLineage<T> {
        public boolean visit(StandardQuadTree<T> var1, String var2);
    }

    private static interface Visitor<T> {
        public boolean visit(StandardQuadTree<T> var1);
    }
}

