/*
 * Decompiled with CFR 0.152.
 */
package org.twak.utils;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;

public class Parallel<I, O> {
    public Parallel(List<I> lines, Work<I, O> work) {
        this(new ListWF<I>(lines), work, (Set<O> o) -> System.out.println("done " + o.size()), true, -1);
    }

    public Parallel(List<I> lines, Work<I, O> work, Complete<O> done, boolean block) {
        this(new ListWF<I>(lines), work, done, block, -1);
    }

    public Parallel(List<I> lines, Work<I, O> work, Complete<O> done, boolean block, int tCount_) {
        this(new ListWF<I>(lines), work, done, block, tCount_);
    }

    public Parallel(final WorkFactory<I> gen, final Work<I, O> work, final Complete<O> done, boolean block, int tCount_) {
        int tCount = tCount_ <= 0 ? Runtime.getRuntime().availableProcessors() / 2 : tCount_;
        final Set os = Collections.synchronizedSet(new HashSet());
        final CountDownLatch cdl = new CountDownLatch(tCount);
        for (int i = 0; i < tCount; ++i) {
            new Thread(){

                @Override
                public void run() {
                    try {
                        do {
                            Object next;
                            if ((next = gen.generateWork()) == null) {
                                return;
                            }
                            try {
                                work.work(next);
                            }
                            catch (Throwable th) {
                                th.printStackTrace();
                            }
                            System.out.println("parallel job done");
                        } while (!gen.shouldAbort());
                    }
                    finally {
                        cdl.countDown();
                    }
                }
            }.start();
        }
        Thread t = new Thread(){

            @Override
            public void run() {
                try {
                    cdl.await();
                    if (done != null) {
                        done.complete(os);
                    }
                    System.out.println("parallel complete done");
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        };
        if (block) {
            t.run();
        } else {
            t.start();
        }
    }

    public static class ListWF<I>
    implements WorkFactory<I> {
        List<I> list;
        AtomicInteger index;
        boolean abort = false;

        public ListWF(List<I> in) {
            this.list = in;
            this.index = new AtomicInteger(-1);
        }

        @Override
        public I generateWork() {
            int i = this.index.incrementAndGet();
            if (i >= this.list.size()) {
                return null;
            }
            System.out.println(this.list.size() - i + " parallel jobs remain");
            return this.list.get(i);
        }

        public void abort() {
            this.abort = true;
        }

        @Override
        public boolean shouldAbort() {
            return this.abort;
        }
    }

    public static interface WorkFactory<I> {
        public I generateWork();

        public boolean shouldAbort();
    }

    public static interface Complete<O> {
        public void complete(Set<O> var1);
    }

    public static interface Work<I, O> {
        public O work(I var1);
    }
}

