/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sedona.common.S2Geography;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import org.apache.sedona.common.S2Geography.Accessors;
import org.apache.sedona.common.S2Geography.GeographyIndex;
import org.apache.sedona.common.S2Geography.PolygonGeography;
import org.apache.sedona.common.S2Geography.ShapeIndexGeography;
import org.apache.sedona.shaded.s2.Projection;
import org.apache.sedona.shaded.s2.R2Vector;
import org.apache.sedona.shaded.s2.S1Angle;
import org.apache.sedona.shaded.s2.S2BooleanOperation;
import org.apache.sedona.shaded.s2.S2EdgeTessellator;
import org.apache.sedona.shaded.s2.S2LatLngRect;
import org.apache.sedona.shaded.s2.S2Loop;
import org.apache.sedona.shaded.s2.S2Point;
import org.apache.sedona.shaded.s2.S2Polygon;

public class Predicates {
    public boolean S2_intersects(ShapeIndexGeography geo1, ShapeIndexGeography geo2, S2BooleanOperation.Options options) {
        return S2BooleanOperation.intersects(geo1.shapeIndex, geo2.shapeIndex, options);
    }

    public boolean S2_equals(ShapeIndexGeography geo1, ShapeIndexGeography geo2, S2BooleanOperation.Options options) {
        return S2BooleanOperation.equals(geo1.shapeIndex, geo2.shapeIndex, options);
    }

    public boolean S2_contains(ShapeIndexGeography geo1, ShapeIndexGeography geo2, S2BooleanOperation.Options options) {
        new Accessors();
        if (Accessors.S2_isEmpty(geo2)) {
            return false;
        }
        return S2BooleanOperation.contains(geo1.shapeIndex, geo2.shapeIndex, options);
    }

    public boolean S2_intersectsBox(ShapeIndexGeography geo1, S2LatLngRect rect, S2BooleanOperation.Options options, double tolerance) {
        Projection.PlateCarreeProjection projection = new Projection.PlateCarreeProjection(180.0);
        S2EdgeTessellator tessellator = new S2EdgeTessellator(projection, S1Angle.degrees(tolerance));
        R2Vector lb = new R2Vector(rect.lngLo().degrees(), rect.latLo().degrees());
        R2Vector rb = new R2Vector(rect.lngHi().degrees(), rect.latLo().degrees());
        R2Vector rt = new R2Vector(rect.lngHi().degrees(), rect.latHi().degrees());
        R2Vector lt = new R2Vector(rect.lngLo().degrees(), rect.latHi().degrees());
        LinkedHashSet<R2Vector> corners = new LinkedHashSet<R2Vector>();
        corners.add(lb);
        corners.add(rb);
        corners.add(rt);
        corners.add(lt);
        ArrayList pts2d = new ArrayList(corners);
        ArrayList<S2Point> vertices = new ArrayList<S2Point>();
        for (int i = 0; i < pts2d.size(); ++i) {
            R2Vector a = (R2Vector)pts2d.get(i);
            R2Vector b = (R2Vector)pts2d.get((i + 1) % pts2d.size());
            tessellator.appendUnprojected(a, b, vertices);
        }
        S2Loop loop = new S2Loop(vertices);
        S2Polygon polygon = new S2Polygon(loop);
        PolygonGeography polygonGeography = new PolygonGeography(polygon);
        GeographyIndex geographyIndex = new GeographyIndex();
        geographyIndex.add(polygonGeography, 0);
        return S2BooleanOperation.intersects(geo1.shapeIndex, geographyIndex.getShapeIndex(), options);
    }
}

