/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sedona.sql.datasources.geopackage.transform;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.Serializable;
import javax.imageio.ImageIO;
import org.apache.sedona.sql.datasources.geopackage.model.Envelope;
import org.apache.sedona.sql.datasources.geopackage.model.ImageFileFormat$;
import org.apache.sedona.sql.datasources.geopackage.model.TileMetadata;
import org.apache.sedona.sql.datasources.geopackage.model.TileRowMetadata;
import org.geotools.api.geometry.Bounds;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridCoverageFactory;
import org.geotools.gce.geotiff.GeoTiffReader;
import org.geotools.geometry.GeneralBounds;
import scala.Array$;
import scala.Enumeration;
import scala.Function1;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class Image$ {
    public static Image$ MODULE$;
    private final String WEBP_HEX;
    private final String PNG_HEX;
    private final Seq<String> TIFF_HEX;
    private final Seq<String> JPEG_HEX;

    static {
        new Image$();
    }

    private String WEBP_HEX() {
        return this.WEBP_HEX;
    }

    private String PNG_HEX() {
        return this.PNG_HEX;
    }

    private Seq<String> TIFF_HEX() {
        return this.TIFF_HEX;
    }

    private Seq<String> JPEG_HEX() {
        return this.JPEG_HEX;
    }

    public GridCoverage2D readImageFile(byte[] byteArray, TileMetadata tileMetadata, TileRowMetadata tileRowMetadata) {
        GridCoverage2D gridCoverage2D;
        boolean bl;
        Enumeration.Value format;
        Enumeration.Value value = format = this.detectFileFormat(byteArray);
        Enumeration.Value value2 = ImageFileFormat$.MODULE$.JPEG();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            bl = true;
        } else {
            Enumeration.Value value4 = ImageFileFormat$.MODULE$.PNG();
            Enumeration.Value value5 = value;
            bl = !(value4 != null ? !value4.equals(value5) : value5 != null);
        }
        if (bl) {
            GridCoverage2D gridCoverage;
            BufferedImage image = this.readImageFromBinary(byteArray);
            gridCoverage2D = gridCoverage = this.createGridCoverage2D(image, tileMetadata, tileRowMetadata);
        } else {
            Enumeration.Value value6 = ImageFileFormat$.MODULE$.WEBP();
            Enumeration.Value value7 = value;
            if (!(value6 != null ? !value6.equals(value7) : value7 != null)) {
                throw new UnsupportedOperationException("WebP format is not supported");
            }
            Enumeration.Value value8 = ImageFileFormat$.MODULE$.TIFF();
            Enumeration.Value value9 = value;
            if (!(value8 != null ? !value8.equals(value9) : value9 != null)) {
                GeoTiffReader reader = new GeoTiffReader((Object)new ByteArrayInputStream(byteArray));
                gridCoverage2D = reader.read(null);
            } else {
                gridCoverage2D = null;
            }
        }
        return gridCoverage2D;
    }

    public Enumeration.Value detectFileFormat(byte[] byteArray) {
        byte[] magicBytes = (byte[])new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(byteArray)).take(12);
        String magicHex = this.bytesToHex(magicBytes);
        if (magicHex.startsWith(this.WEBP_HEX())) {
            String webpCheck;
            String string = webpCheck = new String((byte[])new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(byteArray)).slice(8, 12));
            String string2 = "WEBP";
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                return ImageFileFormat$.MODULE$.WEBP();
            }
        }
        if (magicHex.startsWith(this.PNG_HEX())) {
            return ImageFileFormat$.MODULE$.PNG();
        }
        if (this.JPEG_HEX().exists((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)magicHex.startsWith(x$1)))) {
            return ImageFileFormat$.MODULE$.JPEG();
        }
        if (this.TIFF_HEX().exists((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)magicHex.startsWith(x$1)))) {
            return ImageFileFormat$.MODULE$.TIFF();
        }
        return ImageFileFormat$.MODULE$.UNKNOWN();
    }

    public String bytesToHex(byte[] bytes) {
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(bytes)).map((Function1 & Serializable & scala.Serializable)x$1 -> Image$.$anonfun$bytesToHex$1(BoxesRunTime.unboxToByte((Object)x$1)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).mkString();
    }

    public GridCoverage2D createGridCoverage2D(BufferedImage image, TileMetadata tileMetadata, TileRowMetadata tileRowMetadata) {
        Envelope envelope = tileMetadata.getEnvelope(tileRowMetadata);
        GeneralBounds genEnvelope = new GeneralBounds(new double[]{envelope.minX(), envelope.minY()}, new double[]{envelope.maxX(), envelope.maxY()});
        GridCoverageFactory coverageFactory = new GridCoverageFactory();
        genEnvelope.setCoordinateReferenceSystem(tileMetadata.getSRID());
        return coverageFactory.create((CharSequence)"coverage", (RenderedImage)image, (Bounds)genEnvelope);
    }

    public BufferedImage readImageFromBinary(byte[] imageBinary) {
        ByteArrayInputStream inputStream = new ByteArrayInputStream(imageBinary);
        return ImageIO.read(inputStream);
    }

    public static final /* synthetic */ String $anonfun$bytesToHex$1(byte x$1) {
        return new StringOps(Predef$.MODULE$.augmentString("%02X")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToByte((byte)x$1)}));
    }

    private Image$() {
        MODULE$ = this;
        this.WEBP_HEX = "52494646";
        this.PNG_HEX = "89504E470D0A1A0A";
        this.TIFF_HEX = (Seq)new .colon.colon((Object)"49492A00", (List)new .colon.colon((Object)"4D4D002A", (List)Nil$.MODULE$));
        this.JPEG_HEX = (Seq)new .colon.colon((Object)"FFD8FFE0", (List)new .colon.colon((Object)"FFD8FFE1", (List)new .colon.colon((Object)"FFD8FFE8", (List)Nil$.MODULE$)));
    }
}

