/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.elasticjob.tracing.rdb.storage.converter;

import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import lombok.Generated;
import org.apache.shardingsphere.elasticjob.kernel.tracing.exception.TracingStorageUnavailableException;
import org.apache.shardingsphere.elasticjob.spi.tracing.storage.TracingStorageConfiguration;
import org.apache.shardingsphere.elasticjob.spi.tracing.storage.TracingStorageConfigurationConverter;
import org.apache.shardingsphere.elasticjob.tracing.rdb.config.RDBTracingStorageConfiguration;
import org.apache.shardingsphere.elasticjob.tracing.rdb.storage.datasource.DataSourceRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RDBTracingStorageConfigurationConverter
implements TracingStorageConfigurationConverter<DataSource> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RDBTracingStorageConfigurationConverter.class);

    public TracingStorageConfiguration<DataSource> toConfiguration(DataSource dataSource) {
        try (Connection connection = dataSource.getConnection();){
            log.trace("Try to get connection from {}", (Object)connection.getMetaData().getURL());
        }
        catch (SQLException ex) {
            log.error(ex.getLocalizedMessage(), (Throwable)ex);
            throw new TracingStorageUnavailableException((Throwable)ex);
        }
        RDBTracingStorageConfiguration result = RDBTracingStorageConfiguration.getDataSourceConfiguration(dataSource);
        DataSourceRegistry.getInstance().registerDataSource(result, dataSource);
        return result;
    }

    public Class<DataSource> storageType() {
        return DataSource.class;
    }
}

