/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.elasticjob.script.executor;

import com.google.common.base.Strings;
import java.io.IOException;
import java.util.Properties;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.DefaultExecutor;
import org.apache.shardingsphere.elasticjob.api.ElasticJob;
import org.apache.shardingsphere.elasticjob.api.JobConfiguration;
import org.apache.shardingsphere.elasticjob.kernel.infra.exception.JobConfigurationException;
import org.apache.shardingsphere.elasticjob.kernel.infra.exception.JobSystemException;
import org.apache.shardingsphere.elasticjob.kernel.infra.json.GsonFactory;
import org.apache.shardingsphere.elasticjob.spi.executor.item.param.JobRuntimeService;
import org.apache.shardingsphere.elasticjob.spi.executor.item.param.ShardingContext;
import org.apache.shardingsphere.elasticjob.spi.executor.item.type.TypedJobItemExecutor;

public final class ScriptJobExecutor
implements TypedJobItemExecutor {
    public void process(ElasticJob elasticJob, JobConfiguration jobConfig, JobRuntimeService jobRuntimeService, ShardingContext shardingContext) {
        CommandLine commandLine = CommandLine.parse((String)this.getScriptCommandLine(jobConfig.getProps()));
        commandLine.addArgument(GsonFactory.getGson().toJson((Object)shardingContext), false);
        try {
            new DefaultExecutor().execute(commandLine);
        }
        catch (IOException ex) {
            throw new JobSystemException("Execute script failure.", (Throwable)ex);
        }
    }

    private String getScriptCommandLine(Properties props) {
        String result = props.getProperty("script.command.line");
        if (Strings.isNullOrEmpty((String)result)) {
            throw new JobConfigurationException("Cannot find script command line, job is not executed.", new Object[0]);
        }
        return result;
    }

    public String getType() {
        return "SCRIPT";
    }
}

