/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.client.config;

import java.io.Serializable;
import java.util.Locale;
import java.util.Optional;
import java.util.TimeZone;

public interface ClickHouseOption
extends Serializable {
    public static <T extends Serializable> T fromString(String value, Class<T> clazz) {
        Serializable result;
        if (value == null || clazz == null) {
            throw new IllegalArgumentException("Non-null value and class are required");
        }
        if (clazz == Boolean.TYPE || clazz == Boolean.class) {
            Boolean boolValue = "1".equals(value) || "0".equals(value) ? Boolean.valueOf("1".equals(value)) : Boolean.valueOf(value);
            result = (Serializable)clazz.cast(boolValue);
        } else if (Byte.TYPE == clazz || Byte.class == clazz) {
            result = (Serializable)clazz.cast(value.isEmpty() ? Byte.valueOf((byte)0) : Byte.valueOf(value));
        } else if (Short.TYPE == clazz || Short.class == clazz) {
            result = (Serializable)clazz.cast(value.isEmpty() ? Short.valueOf((short)0) : Short.valueOf(value));
        } else if (Integer.TYPE == clazz || Integer.class == clazz) {
            result = (Serializable)clazz.cast(value.isEmpty() ? Integer.valueOf(0) : Integer.valueOf(value));
        } else if (Long.TYPE == clazz || Long.class == clazz) {
            result = (Serializable)clazz.cast(value.isEmpty() ? Long.valueOf(0L) : Long.valueOf(value));
        } else if (Float.TYPE == clazz || Float.class == clazz) {
            result = (Serializable)clazz.cast(value.isEmpty() ? Float.valueOf(0.0f) : Float.valueOf(value));
        } else if (Double.TYPE == clazz || Double.class == clazz) {
            result = (Serializable)clazz.cast(value.isEmpty() ? Double.valueOf(0.0) : Double.valueOf(value));
        } else if (Enum.class.isAssignableFrom(clazz)) {
            Enum enumValue = null;
            try {
                enumValue = (Enum)Enum.valueOf(clazz, value);
            }
            catch (IllegalArgumentException exp) {
                for (Enum e : (Enum[])clazz.getEnumConstants()) {
                    if (!e.name().equalsIgnoreCase(value)) continue;
                    enumValue = e;
                    break;
                }
            }
            if (enumValue == null) {
                throw new IllegalArgumentException("No enum constant " + clazz.getCanonicalName() + "." + value);
            }
            result = enumValue;
        } else {
            result = TimeZone.class.isAssignableFrom(clazz) ? TimeZone.getTimeZone(value) : (Serializable)clazz.cast(value);
        }
        return (T)result;
    }

    public Serializable getDefaultValue();

    default public Optional<String> getDefaultValueFromEnvVar() {
        String value = System.getenv(this.getEnvironmentVariable());
        if (value != null) {
            value = value.trim();
        }
        return Optional.ofNullable(value);
    }

    default public Optional<String> getDefaultValueFromSysProp() {
        String value = System.getProperty(this.getSystemProperty());
        if (value != null) {
            value = value.trim();
        }
        return Optional.ofNullable(value);
    }

    public String getDescription();

    default public Serializable getEffectiveDefaultValue() {
        Optional<String> value = this.getDefaultValueFromEnvVar();
        if (!value.isPresent() || value.get().isEmpty()) {
            value = this.getDefaultValueFromSysProp();
        }
        if (!value.isPresent() || value.get().isEmpty()) {
            return this.getDefaultValue();
        }
        return ClickHouseOption.fromString(value.get(), this.getValueType());
    }

    default public <T> T getEffectiveValue(T value) {
        Object result = value == null ? this.getEffectiveDefaultValue() : value;
        return result;
    }

    public String getKey();

    default public String getPrefix() {
        return "CHC";
    }

    default public String getEnvironmentVariable() {
        String name = this.name().toUpperCase(Locale.ROOT);
        String prefix = this.getPrefix().toUpperCase(Locale.ROOT);
        return new StringBuilder(prefix.length() + name.length() + 1).append(prefix).append('_').append(name).toString();
    }

    default public String getSystemProperty() {
        String name = this.name().toLowerCase(Locale.ROOT);
        String prefix = this.getPrefix().toLowerCase(Locale.ROOT);
        return new StringBuilder(prefix.length() + name.length() + 1).append(prefix).append('_').append(name).toString();
    }

    public Class<? extends Serializable> getValueType();

    public String name();
}

