/*
 * Decompiled with CFR 0.152.
 */
package com.qq.tars.net.core;

import com.qq.tars.net.core.Request;
import com.qq.tars.net.core.Response;
import com.qq.tars.net.protocol.ProtocolFactory;
import java.io.IOException;
import java.nio.channels.SelectableChannel;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public abstract class Session {
    protected SessionStatus status = SessionStatus.NOT_CONNECTED;
    protected long lastOperationTime = System.currentTimeMillis();
    protected boolean keepAlive = true;
    protected CountDownLatch connectLatch = new CountDownLatch(1);

    public abstract void close() throws IOException;

    public abstract void asyncClose() throws IOException;

    protected abstract void read() throws IOException;

    protected abstract void accept() throws IOException;

    public abstract void write(Request var1) throws IOException;

    public abstract void write(Response var1) throws IOException;

    public abstract void setChannel(SelectableChannel var1) throws IOException;

    public abstract String getRemoteIp();

    public abstract int getRemotePort();

    public abstract ProtocolFactory getProtocolFactory();

    public SessionStatus getStatus() {
        return this.status;
    }

    public void setStatus(SessionStatus status) {
        this.status = status;
    }

    public void finishConnect() {
        this.connectLatch.countDown();
    }

    public boolean waitToConnect(long connectTimeout) {
        try {
            return this.connectLatch.await(connectTimeout, TimeUnit.MILLISECONDS);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }

    public void updateLastOperationTime() {
        this.lastOperationTime = System.currentTimeMillis();
    }

    public long getLastOperationTime() {
        return this.lastOperationTime;
    }

    public void setKeepAlive(boolean keepAlive) {
        this.keepAlive = keepAlive;
    }

    public boolean isKeepAlive() {
        return this.keepAlive;
    }

    public static enum SessionStatus {
        NOT_CONNECTED,
        CLIENT_CONNECTED,
        SERVER_CONNECTED,
        CLOSED;

    }
}

