/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.internal.shared;

import java.util.HashMap;
import java.util.Map;
import org.apache.sis.metadata.iso.extent.Extents;
import org.apache.sis.referencing.IdentifiedObjects;
import org.apache.sis.referencing.datum.DatumOrEnsemble;
import org.apache.sis.referencing.internal.shared.ReferencingFactoryContainer;
import org.apache.sis.referencing.internal.shared.ReferencingUtilities;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ArraysExt;
import org.opengis.metadata.extent.Extent;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.crs.CRSFactory;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.GeodeticCRS;
import org.opengis.referencing.crs.GeographicCRS;
import org.opengis.referencing.crs.ProjectedCRS;
import org.opengis.referencing.crs.VerticalCRS;
import org.opengis.referencing.cs.CSFactory;
import org.opengis.referencing.cs.CartesianCS;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.cs.EllipsoidalCS;
import org.opengis.referencing.datum.VerticalDatum;
import org.opengis.referencing.operation.Conversion;
import org.opengis.referencing.operation.CoordinateOperationFactory;
import org.opengis.referencing.operation.Projection;
import org.opengis.util.FactoryException;

public final class EllipsoidalHeightCombiner {
    private final ReferencingFactoryContainer factories;

    public EllipsoidalHeightCombiner() {
        this.factories = new ReferencingFactoryContainer();
    }

    public EllipsoidalHeightCombiner(ReferencingFactoryContainer c) {
        this.factories = c;
    }

    public EllipsoidalHeightCombiner(CRSFactory crsFactory, CSFactory csFactory, CoordinateOperationFactory opFactory) {
        this.factories = new ReferencingFactoryContainer(null, crsFactory, csFactory, null, opFactory, null);
    }

    public final CoordinateReferenceSystem createCompoundCRS(CoordinateReferenceSystem ... components) throws FactoryException {
        return this.createCompoundCRS(EllipsoidalHeightCombiner.properties(components), components);
    }

    public final CoordinateReferenceSystem createCompoundCRS(Map<String, ?> properties, CoordinateReferenceSystem ... components) throws FactoryException {
        for (int i = 0; i < components.length; ++i) {
            Map<String, ?> crsProps;
            CoordinateSystem cs2D;
            VerticalDatum datum;
            CoordinateReferenceSystem vertical = components[i];
            if (!(vertical instanceof VerticalCRS) || !ReferencingUtilities.isEllipsoidalHeight(datum = DatumOrEnsemble.asDatum((VerticalCRS)vertical))) continue;
            int axisPosition = 0;
            CoordinateReferenceSystem crs = null;
            if (i == 0 || (cs2D = EllipsoidalHeightCombiner.getCsIfHorizontal2D(crs = components[i - 1])) == null) {
                if (i + 1 >= components.length || (cs2D = EllipsoidalHeightCombiner.getCsIfHorizontal2D(crs = components[i + 1])) == null) continue;
                axisPosition = 1;
            }
            CoordinateSystemAxis[] axes = new CoordinateSystemAxis[3];
            axes[axisPosition++] = cs2D.getAxis(0);
            axes[axisPosition++] = cs2D.getAxis(1);
            axes[axisPosition %= 3] = vertical.getCoordinateSystem().getAxis(0);
            Map<String, ?> csProps = IdentifiedObjects.getProperties((IdentifiedObject)cs2D, "identifiers");
            Map<String, ?> map = crsProps = components.length == 2 ? properties : IdentifiedObjects.getProperties((IdentifiedObject)crs, "identifiers");
            if (crs instanceof GeodeticCRS) {
                GeodeticCRS geod = (GeodeticCRS)crs;
                EllipsoidalCS cs3D = this.factories.getCSFactory().createEllipsoidalCS(csProps, axes[0], axes[1], axes[2]);
                crs = this.factories.getCRSFactory().createGeographicCRS(crsProps, DatumOrEnsemble.asDatum(geod), cs3D);
            } else {
                ProjectedCRS proj = (ProjectedCRS)crs;
                GeographicCRS base = proj.getBaseCRS();
                if (base.getCoordinateSystem().getDimension() == 2) {
                    base = (GeographicCRS)this.createCompoundCRS(IdentifiedObjects.getProperties((IdentifiedObject)base, "identifiers"), new CoordinateReferenceSystem[]{base, vertical});
                }
                Projection fromBase = proj.getConversionFromBase();
                fromBase = this.factories.getCoordinateOperationFactory().createDefiningConversion(IdentifiedObjects.getProperties((IdentifiedObject)fromBase, new String[0]), fromBase.getMethod(), fromBase.getParameterValues());
                CartesianCS cs3D = this.factories.getCSFactory().createCartesianCS(csProps, axes[0], axes[1], axes[2]);
                crs = this.factories.getCRSFactory().createProjectedCRS(crsProps, base, (Conversion)fromBase, cs3D);
            }
            components = (CoordinateReferenceSystem[])ArraysExt.remove((Object[])components, (int)i, (int)1);
            if (axisPosition != 0) {
                --i;
            }
            components[i] = crs;
        }
        switch (components.length) {
            case 0: {
                return null;
            }
            case 1: {
                return components[0];
            }
        }
        return this.factories.getCRSFactory().createCompoundCRS(properties, components);
    }

    private static CoordinateSystem getCsIfHorizontal2D(CoordinateReferenceSystem crs) {
        CoordinateSystem cs;
        boolean isProjected = crs instanceof ProjectedCRS;
        if ((isProjected || crs instanceof GeodeticCRS) && (cs = crs.getCoordinateSystem()).getDimension() == 2 && (isProjected || cs instanceof EllipsoidalCS)) {
            return cs;
        }
        return null;
    }

    static Map<String, Object> properties(CoordinateReferenceSystem ... components) {
        StringBuilder name = new StringBuilder(40);
        Extent domain = null;
        for (int i = 0; i < components.length; ++i) {
            CoordinateReferenceSystem crs = components[i];
            ArgumentChecks.ensureNonNullElement((String)"components", (int)i, (Object)crs);
            if (i != 0) {
                name.append(" + ");
            }
            name.append(crs.getName().getCode());
            domain = Extents.intersection(domain, (Extent)crs.getDomainOfValidity());
        }
        HashMap<String, Object> properties = new HashMap<String, Object>(4);
        properties.put("name", name.toString());
        properties.put("domainOfValidity", domain);
        return properties;
    }
}

