/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation.transform;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.sis.io.wkt.Convention;
import org.apache.sis.io.wkt.FormattableObject;
import org.apache.sis.io.wkt.Formatter;
import org.apache.sis.parameter.Parameterized;
import org.apache.sis.referencing.internal.Resources;
import org.apache.sis.referencing.operation.matrix.Matrices;
import org.apache.sis.referencing.operation.matrix.MatrixSIS;
import org.apache.sis.referencing.operation.provider.GeocentricAffine;
import org.apache.sis.referencing.operation.transform.AbstractMathTransform;
import org.apache.sis.referencing.operation.transform.ConcatenatedTransform1D;
import org.apache.sis.referencing.operation.transform.ConcatenatedTransform2D;
import org.apache.sis.referencing.operation.transform.ConcatenatedTransformDirect;
import org.apache.sis.referencing.operation.transform.ConcatenatedTransformDirect1D;
import org.apache.sis.referencing.operation.transform.ConcatenatedTransformDirect2D;
import org.apache.sis.referencing.operation.transform.ContextualParameters;
import org.apache.sis.referencing.operation.transform.DefaultMathTransformFactory;
import org.apache.sis.referencing.operation.transform.DomainDefinition;
import org.apache.sis.referencing.operation.transform.IterationStrategy;
import org.apache.sis.referencing.operation.transform.LinearTransform;
import org.apache.sis.referencing.operation.transform.MathTransforms;
import org.apache.sis.referencing.operation.transform.OnewayLinearTransform;
import org.apache.sis.referencing.operation.transform.TransformJoiner;
import org.apache.sis.system.Semaphores;
import org.apache.sis.util.Classes;
import org.apache.sis.util.ComparisonMode;
import org.apache.sis.util.Utilities;
import org.apache.sis.util.internal.shared.Strings;
import org.apache.sis.util.resources.Errors;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.Envelope;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransform1D;
import org.opengis.referencing.operation.MathTransform2D;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.NoninvertibleTransformException;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.FactoryException;

class ConcatenatedTransform
extends AbstractMathTransform
implements Serializable {
    private static final long serialVersionUID = 5772066656987558634L;
    protected final MathTransform transform1;
    protected final MathTransform transform2;
    private MathTransform inverse;

    protected ConcatenatedTransform(MathTransform transform1, MathTransform transform2) {
        this.transform1 = transform1;
        this.transform2 = transform2;
        if (!this.isValid()) {
            throw new IllegalArgumentException(Resources.format((short)3, ConcatenatedTransform.getName(transform1), ConcatenatedTransform.getName(transform2)));
        }
    }

    private static String getName(MathTransform transform) {
        String name;
        ContextualParameters params = null;
        if (transform instanceof AbstractMathTransform) {
            params = ((AbstractMathTransform)transform).getContextualParameters();
        }
        if (params == null && transform instanceof Parameterized) {
            params = ((Parameterized)transform).getParameterValues();
        }
        if (params != null && (name = Strings.trimOrNull((String)params.getDescriptor().getName().getCode())) != null) {
            return name;
        }
        return Classes.getShortClassName((Object)transform);
    }

    private static void expand(List<MathTransform> steps, List<ConcatenatedTransform> pairs, boolean first) {
        int replaceIndex = steps.size() - 1;
        MathTransform tr = steps.get(replaceIndex);
        while (tr instanceof ConcatenatedTransform) {
            ConcatenatedTransform ct = (ConcatenatedTransform)tr;
            pairs.add(ct);
            steps.set(replaceIndex, ct.transform1);
            steps.add(replaceIndex + 1, ct.transform2);
            if (first) {
                tr = ct.transform1;
                continue;
            }
            tr = ct.transform2;
            ++replaceIndex;
        }
    }

    public static MathTransform create(MathTransformFactory factory, MathTransform ... transforms) throws FactoryException, MismatchedDimensionException {
        boolean changed;
        for (int i = 1; i < transforms.length; ++i) {
            int dim2;
            MathTransform tr1 = transforms[i - 1];
            MathTransform tr2 = transforms[i];
            int dim1 = tr1.getTargetDimensions();
            if (dim1 == (dim2 = tr2.getSourceDimensions())) continue;
            String message = Resources.format((short)3, ConcatenatedTransform.getName(tr1), ConcatenatedTransform.getName(tr2));
            throw new MismatchedDimensionException(message + " " + Errors.format((short)100, (Object)dim1, (Object)dim2));
        }
        ArrayList<MathTransform> steps = new ArrayList<MathTransform>();
        ArrayList<ConcatenatedTransform> pairs = new ArrayList<ConcatenatedTransform>();
        TransformJoiner context = new TransformJoiner(steps, factory, pairs);
        do {
            for (MathTransform tr : transforms) {
                if (tr.isIdentity()) continue;
                if (steps.isEmpty()) {
                    steps.add(tr);
                    continue;
                }
                ConcatenatedTransform.expand(steps, pairs, false);
                steps.add(tr);
                ConcatenatedTransform.expand(steps, pairs, true);
            }
            changed = context.simplify();
            switch (steps.size()) {
                case 0: {
                    return MathTransforms.identity(transforms[0].getSourceDimensions());
                }
                case 1: {
                    return steps.get(0);
                }
            }
            if (!changed) continue;
            transforms = (MathTransform[])steps.toArray(MathTransform[]::new);
            steps.clear();
            pairs.clear();
        } while (changed);
        MathTransform concatenated = null;
        int i = steps.size();
        while (--i >= 0) {
            MathTransform tr = steps.get(i);
            if (!(tr instanceof AbstractMathTransform)) continue;
            context.reset(i);
            ((AbstractMathTransform)tr).tryConcatenate(context);
            MathTransform replacement = context.replacement;
            if (replacement == null || concatenated != null && ConcatenatedTransform.getStepCount(replacement) >= ConcatenatedTransform.getStepCount(concatenated)) continue;
            concatenated = replacement;
        }
        if (concatenated == null) {
            context.reassemble();
            concatenated = steps.get(0);
            int count = steps.size();
            for (int i2 = 1; i2 < count; ++i2) {
                MathTransform tr2 = steps.get(i2);
                int dimSource = concatenated.getSourceDimensions();
                int dimTarget = tr2.getTargetDimensions();
                if (dimSource == 1 && dimTarget == 1) {
                    if (concatenated instanceof MathTransform1D && tr2 instanceof MathTransform1D) {
                        concatenated = new ConcatenatedTransformDirect1D((MathTransform1D)concatenated, (MathTransform1D)tr2);
                        continue;
                    }
                    concatenated = new ConcatenatedTransform1D(concatenated, tr2);
                    continue;
                }
                if (dimSource == 2 && dimTarget == 2) {
                    if (concatenated instanceof MathTransform2D && tr2 instanceof MathTransform2D) {
                        concatenated = new ConcatenatedTransformDirect2D((MathTransform2D)concatenated, (MathTransform2D)tr2);
                        continue;
                    }
                    concatenated = new ConcatenatedTransform2D(concatenated, tr2);
                    continue;
                }
                concatenated = dimSource == concatenated.getTargetDimensions() && dimTarget == tr2.getSourceDimensions() ? new ConcatenatedTransformDirect(concatenated, tr2) : new ConcatenatedTransform(concatenated, tr2);
            }
        }
        assert (ConcatenatedTransform.isValid(MathTransforms.getSteps(concatenated))) : concatenated;
        return concatenated;
    }

    private static boolean isValid(List<MathTransform> steps) {
        boolean wasLinear = false;
        MathTransform previous = null;
        for (MathTransform step : steps) {
            if (previous != null && previous.getTargetDimensions() != step.getSourceDimensions()) {
                return false;
            }
            if (step instanceof LinearTransform) {
                if (wasLinear) {
                    return false;
                }
                wasLinear = true;
            } else {
                wasLinear = false;
            }
            previous = step;
        }
        return true;
    }

    boolean isValid() {
        return this.transform1.getTargetDimensions() == this.transform2.getSourceDimensions();
    }

    @Override
    public final int getSourceDimensions() {
        return this.transform1.getSourceDimensions();
    }

    @Override
    public final int getTargetDimensions() {
        return this.transform2.getTargetDimensions();
    }

    private int getStepCount() {
        return ConcatenatedTransform.getStepCount(this.transform1) + ConcatenatedTransform.getStepCount(this.transform2);
    }

    private static int getStepCount(MathTransform transform) {
        if (transform.isIdentity()) {
            return 0;
        }
        if (!(transform instanceof ConcatenatedTransform)) {
            return 1;
        }
        return ((ConcatenatedTransform)transform).getStepCount();
    }

    public final List<MathTransform> getSteps() {
        ArrayList<MathTransform> transforms = new ArrayList<MathTransform>(5);
        this.addStepsTo(transforms);
        return transforms;
    }

    private List<Object> getPseudoSteps() {
        ArrayList<Object> transforms = new ArrayList<Object>();
        this.addStepsTo(transforms);
        for (int i = 0; i < transforms.size(); ++i) {
            Object step = transforms.get(i);
            if (!(step instanceof AbstractMathTransform)) continue;
            i = ((AbstractMathTransform)step).beforeFormat(transforms, i, false);
        }
        Matrix after = null;
        int i = transforms.size();
        while (--i >= 0) {
            Object step = transforms.get(i);
            if (step instanceof Matrix) {
                if (after != null) {
                    MatrixSIS merged = Matrices.multiply(after, (Matrix)step);
                    if (merged.isIdentity()) {
                        transforms.subList(i, i + 2).clear();
                        after = null;
                        continue;
                    }
                    transforms.set(i, MathTransforms.linear(merged));
                    transforms.remove(i + 1);
                    after = merged;
                    continue;
                }
                after = (Matrix)step;
                continue;
            }
            after = null;
        }
        GeocentricAffine.asDatumShift(transforms);
        return transforms;
    }

    private void addStepsTo(List<? super MathTransform> transforms) {
        if (this.transform1 instanceof ConcatenatedTransform) {
            ((ConcatenatedTransform)this.transform1).addStepsTo(transforms);
        } else {
            transforms.add((MathTransform)this.transform1);
        }
        if (this.transform2 instanceof ConcatenatedTransform) {
            ((ConcatenatedTransform)this.transform2).addStepsTo(transforms);
        } else {
            transforms.add((MathTransform)this.transform2);
        }
    }

    private Parameterized getParameterised() {
        Parameterized param = null;
        List<Object> transforms = this.getPseudoSteps();
        if (transforms.size() == 1 || Semaphores.TRANSFORM_ENCLOSED_IN_OPERATION.get()) {
            for (Object candidate : transforms) {
                if (candidate instanceof Matrix || MathTransforms.isLinear(candidate)) continue;
                if (param == null && candidate instanceof Parameterized) {
                    param = (Parameterized)candidate;
                    continue;
                }
                return null;
            }
        }
        return param;
    }

    @Override
    public ParameterDescriptorGroup getParameterDescriptors() {
        Parameterized param = this.getParameterised();
        return param != null ? param.getParameterDescriptors() : null;
    }

    @Override
    public ParameterValueGroup getParameterValues() {
        Parameterized param = this.getParameterised();
        return param != null ? param.getParameterValues() : null;
    }

    @Override
    public DirectPosition transform(DirectPosition ptSrc, DirectPosition ptDst) throws TransformException {
        assert (this.isValid());
        return this.transform2.transform(this.transform1.transform(ptSrc, null), ptDst);
    }

    @Override
    public Matrix transform(double[] srcPts, int srcOff, double[] dstPts, int dstOff, boolean derivate) throws TransformException {
        int offset;
        double[] buffer;
        int targetDim;
        assert (this.isValid());
        int bufferDim = this.transform2.getSourceDimensions();
        if (bufferDim > (targetDim = this.transform2.getTargetDimensions())) {
            buffer = new double[bufferDim];
            offset = 0;
        } else {
            buffer = dstPts;
            offset = dstOff;
        }
        if (derivate) {
            Matrix matrix1 = MathTransforms.derivativeAndTransform(this.transform1, srcPts, srcOff, buffer, offset);
            Matrix matrix2 = MathTransforms.derivativeAndTransform(this.transform2, buffer, offset, dstPts, dstOff);
            return Matrices.multiply(matrix2, matrix1);
        }
        this.transform1.transform(srcPts, srcOff, buffer, offset, 1);
        this.transform2.transform(buffer, offset, dstPts, dstOff, 1);
        return null;
    }

    @Override
    public void transform(double[] srcPts, int srcOff, double[] dstPts, int dstOff, int numPts) throws TransformException {
        int targetDim;
        assert (this.isValid());
        int bufferDim = this.transform2.getSourceDimensions();
        if (bufferDim <= (targetDim = this.transform2.getTargetDimensions())) {
            this.transform1.transform(srcPts, srcOff, dstPts, dstOff, numPts);
            this.transform2.transform(dstPts, dstOff, dstPts, dstOff, numPts);
            return;
        }
        if (numPts <= 0) {
            return;
        }
        boolean descending = false;
        int sourceDim = this.transform1.getSourceDimensions();
        int numBuf = numPts;
        int length = numBuf * bufferDim;
        if (length > 512) {
            numBuf = Math.max(1, 512 / bufferDim);
            if (srcPts == dstPts) {
                switch (IterationStrategy.suggest(srcOff, numBuf * sourceDim, dstOff, numBuf * targetDim, numPts)) {
                    default: {
                        numBuf = numPts;
                        break;
                    }
                    case ASCENDING: {
                        break;
                    }
                    case DESCENDING: {
                        int shift = numPts - numBuf;
                        srcOff += shift * sourceDim;
                        sourceDim = -sourceDim;
                        dstOff += shift * targetDim;
                        targetDim = -targetDim;
                        descending = true;
                        break;
                    }
                }
            }
            length = numBuf * bufferDim;
        }
        double[] buf = new double[length];
        do {
            if (!descending && numBuf > numPts) {
                numBuf = numPts;
            }
            this.transform1.transform(srcPts, srcOff, buf, 0, numBuf);
            this.transform2.transform(buf, 0, dstPts, dstOff, numBuf);
            if (descending && numBuf > (numPts -= numBuf)) {
                numBuf = numPts;
            }
            srcOff += numBuf * sourceDim;
            dstOff += numBuf * targetDim;
        } while (numPts != 0);
    }

    @Override
    public void transform(float[] srcPts, int srcOff, float[] dstPts, int dstOff, int numPts) throws TransformException {
        assert (this.isValid());
        if (numPts <= 0) {
            return;
        }
        boolean descending = false;
        int sourceDim = this.transform1.getSourceDimensions();
        int bufferDim = this.transform1.getTargetDimensions();
        int numBuf = numPts;
        int targetDim = this.transform2.getTargetDimensions();
        int dimension = Math.max(targetDim, bufferDim);
        int length = numBuf * dimension;
        if (length > 512) {
            numBuf = Math.max(1, 512 / dimension);
            if (srcPts == dstPts) {
                switch (IterationStrategy.suggest(srcOff, numBuf * sourceDim, dstOff, numBuf * targetDim, numPts)) {
                    default: {
                        numBuf = numPts;
                        break;
                    }
                    case ASCENDING: {
                        break;
                    }
                    case DESCENDING: {
                        int shift = numPts - numBuf;
                        srcOff += shift * sourceDim;
                        sourceDim = -sourceDim;
                        dstOff += shift * targetDim;
                        targetDim = -targetDim;
                        descending = true;
                        break;
                    }
                }
            }
            length = numBuf * dimension;
        }
        double[] buf = new double[length];
        do {
            if (!descending && numBuf > numPts) {
                numBuf = numPts;
            }
            this.transform1.transform(srcPts, srcOff, buf, 0, numBuf);
            this.transform2.transform(buf, 0, dstPts, dstOff, numBuf);
            if (descending && numBuf > (numPts -= numBuf)) {
                numBuf = numPts;
            }
            srcOff += numBuf * sourceDim;
            dstOff += numBuf * targetDim;
        } while (numPts != 0);
    }

    @Override
    public void transform(double[] srcPts, int srcOff, float[] dstPts, int dstOff, int numPts) throws TransformException {
        assert (this.isValid());
        if (numPts <= 0) {
            return;
        }
        int sourceDim = this.transform1.getSourceDimensions();
        int bufferDim = this.transform1.getTargetDimensions();
        int numBuf = numPts;
        int targetDim = this.transform2.getTargetDimensions();
        int dimension = Math.max(targetDim, bufferDim);
        int length = numBuf * dimension;
        if (length > 512) {
            numBuf = Math.max(1, 512 / dimension);
            length = numBuf * dimension;
        }
        double[] buf = new double[length];
        do {
            if (numBuf > numPts) {
                numBuf = numPts;
            }
            this.transform1.transform(srcPts, srcOff, buf, 0, numBuf);
            this.transform2.transform(buf, 0, dstPts, dstOff, numBuf);
            srcOff += numBuf * sourceDim;
            dstOff += numBuf * targetDim;
        } while ((numPts -= numBuf) != 0);
    }

    @Override
    public void transform(float[] srcPts, int srcOff, double[] dstPts, int dstOff, int numPts) throws TransformException {
        int targetDim;
        assert (this.isValid());
        int bufferDim = this.transform2.getSourceDimensions();
        if (bufferDim <= (targetDim = this.transform2.getTargetDimensions())) {
            this.transform1.transform(srcPts, srcOff, dstPts, dstOff, numPts);
            this.transform2.transform(dstPts, dstOff, dstPts, dstOff, numPts);
            return;
        }
        if (numPts <= 0) {
            return;
        }
        int numBuf = numPts;
        int length = numBuf * bufferDim;
        if (length > 512) {
            numBuf = Math.max(1, 512 / bufferDim);
            length = numBuf * bufferDim;
        }
        double[] buf = new double[length];
        int sourceDim = this.getSourceDimensions();
        do {
            if (numBuf > numPts) {
                numBuf = numPts;
            }
            this.transform1.transform(srcPts, srcOff, buf, 0, numBuf);
            this.transform2.transform(buf, 0, dstPts, dstOff, numBuf);
            srcOff += numBuf * sourceDim;
            dstOff += numBuf * targetDim;
        } while ((numPts -= numBuf) != 0);
    }

    @Override
    public Matrix derivative(DirectPosition point) throws TransformException {
        Matrix matrix1 = this.transform1.derivative(point);
        Matrix matrix2 = this.transform2.derivative(this.transform1.transform(point, null));
        return Matrices.multiply(matrix2, matrix1);
    }

    @Override
    public synchronized MathTransform inverse() throws NoninvertibleTransformException {
        assert (this.isValid());
        if (this.inverse == null) {
            try {
                this.inverse = ConcatenatedTransform.create(DefaultMathTransformFactory.provider(), this.transform2.inverse(), this.transform1.inverse());
                ConcatenatedTransform.setInverse(this.inverse, this);
            }
            catch (FactoryException e) {
                throw new NoninvertibleTransformException(Resources.format((short)53), (Throwable)e);
            }
        }
        return this.inverse;
    }

    static void setInverse(MathTransform forward, MathTransform inverse) {
        if (forward instanceof ConcatenatedTransform) {
            ConcatenatedTransform ct = (ConcatenatedTransform)forward;
            assert (OnewayLinearTransform.isNullOrDelegate(ct.inverse, inverse));
            ct.inverse = inverse;
        }
    }

    @Override
    public final Optional<Envelope> getDomain(DomainDefinition criteria) throws TransformException {
        MathTransform head = this.transform1.inverse();
        criteria.estimateOnInverse(this.transform2.inverse(), head);
        criteria.estimateOnInverse(head);
        return criteria.result();
    }

    @Override
    public boolean isIdentity() {
        return this.transform1.isIdentity() && this.transform2.isIdentity();
    }

    @Override
    protected int computeHashCode() {
        return super.computeHashCode() ^ this.getSteps().hashCode();
    }

    @Override
    public boolean equals(Object object, ComparisonMode mode) {
        if (object == this) {
            return true;
        }
        if (object instanceof ConcatenatedTransform) {
            ConcatenatedTransform that = (ConcatenatedTransform)object;
            return Utilities.deepEquals(this.getSteps(), that.getSteps(), (ComparisonMode)mode);
        }
        return false;
    }

    @Override
    protected String formatTo(Formatter formatter) {
        List<Object> transforms = formatter.getConvention() == Convention.INTERNAL ? this.getSteps() : this.getPseudoSteps();
        if (transforms.size() == 1) {
            return formatter.delegateTo(transforms.get(0));
        }
        for (Object step : transforms) {
            formatter.newLine();
            if (step instanceof FormattableObject) {
                formatter.append((FormattableObject)step);
                continue;
            }
            if (step instanceof MathTransform) {
                formatter.append((MathTransform)step);
                continue;
            }
            formatter.append(MathTransforms.linear((Matrix)step));
        }
        return "Concat_MT";
    }
}

