/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.landsat;

import java.awt.Dimension;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.nio.charset.StandardCharsets;
import java.time.DateTimeException;
import java.time.LocalDate;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.temporal.Temporal;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.sis.measure.Units;
import org.apache.sis.metadata.ModifiableMetadata;
import org.apache.sis.metadata.iso.DefaultMetadata;
import org.apache.sis.metadata.iso.content.DefaultAttributeGroup;
import org.apache.sis.metadata.iso.content.DefaultCoverageDescription;
import org.apache.sis.metadata.iso.content.DefaultSampleDimension;
import org.apache.sis.referencing.CRS;
import org.apache.sis.referencing.CommonCRS;
import org.apache.sis.referencing.internal.shared.CoordinateOperations;
import org.apache.sis.referencing.internal.shared.GeodeticObjectBuilder;
import org.apache.sis.referencing.internal.shared.ReferencingFactoryContainer;
import org.apache.sis.referencing.operation.provider.TransverseMercator;
import org.apache.sis.referencing.operation.transform.MathTransformBuilder;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.DataStoreReferencingException;
import org.apache.sis.storage.base.MetadataBuilder;
import org.apache.sis.storage.event.StoreListeners;
import org.apache.sis.storage.landsat.Band;
import org.apache.sis.storage.landsat.BandGroupName;
import org.apache.sis.storage.landsat.BandName;
import org.apache.sis.storage.landsat.LandsatStore;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.Characters;
import org.apache.sis.util.collection.Containers;
import org.apache.sis.util.internal.shared.Strings;
import org.apache.sis.util.resources.Errors;
import org.apache.sis.util.resources.Vocabulary;
import org.opengis.metadata.Metadata;
import org.opengis.metadata.citation.DateType;
import org.opengis.metadata.content.CoverageContentType;
import org.opengis.metadata.content.TransferFunctionType;
import org.opengis.metadata.identification.TopicCategory;
import org.opengis.metadata.maintenance.ScopeCode;
import org.opengis.metadata.spatial.DimensionNameType;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.ReferenceSystem;
import org.opengis.referencing.crs.ProjectedCRS;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.util.FactoryException;
import org.opengis.util.NoSuchIdentifierException;

final class MetadataReader
extends MetadataBuilder {
    static final Pattern CREDIT = Pattern.compile("\\bcourtesy\\h+of\\h+(the)?\\b\\s*", 2);
    private static final String LINEAGE_SUFFIX = "_RECORD";
    private static final String BAND_SUFFIX = "_BAND";
    private static final String END = "END";
    private final LandsatStore store;
    private final StoreListeners listeners;
    private String filename;
    private String group;
    private String lineageGroup;
    private Temporal sceneTime;
    private final double[] corners;
    private static final int NUM_COORDINATES = 8;
    private static final int PROJECTED = 0;
    private static final int GEOGRAPHIC = 8;
    private final EnumMap<BandGroupName, Dimension> gridSizes;
    final EnumMap<BandName, Band> bands;
    private final BandName[] bandEnumerations;
    private CommonCRS datum;
    private short utmZone;
    private MathTransformBuilder projection;
    private final ReferencingFactoryContainer factories;

    MetadataReader(LandsatStore store, String filename, StoreListeners listeners) {
        this.store = store;
        this.filename = filename;
        this.listeners = listeners;
        this.factories = new ReferencingFactoryContainer();
        this.corners = new double[16];
        this.gridSizes = new EnumMap(BandGroupName.class);
        this.bands = new EnumMap(BandName.class);
        this.bandEnumerations = BandName.values();
        Arrays.fill(this.corners, Double.NaN);
    }

    void read(BufferedReader reader) throws IOException, DataStoreException {
        String line;
        this.newCoverage(true);
        while ((line = reader.readLine()) != null) {
            int end = CharSequences.skipTrailingWhitespaces((CharSequence)line, (int)0, (int)line.length());
            int start = CharSequences.skipLeadingWhitespaces((CharSequence)line, (int)0, (int)end);
            if (start >= end || line.charAt(start) == '#') continue;
            int separator = line.indexOf(61, start);
            if (separator < 0) {
                if (end - start != END.length() || !line.regionMatches(true, start, END, 0, END.length())) {
                    throw new DataStoreException(this.errors().getString((short)136, (Object)line));
                }
                return;
            }
            String key = line.substring(start, CharSequences.skipTrailingWhitespaces((CharSequence)line, (int)start, (int)separator)).toUpperCase(Locale.US);
            int band = 0;
            int i = key.length();
            while (--i >= 0) {
                char c = key.charAt(i);
                if (c >= '0' && c <= '9') continue;
                if (c != '_' || !key.startsWith(BAND_SUFFIX, i - BAND_SUFFIX.length())) break;
                try {
                    band = Integer.parseInt(key.substring(++i));
                    key = key.substring(0, i);
                }
                catch (NumberFormatException e) {
                    this.warning(key, reader, e);
                }
                break;
            }
            if (end - (start = CharSequences.skipLeadingWhitespaces((CharSequence)line, (int)(separator + 1), (int)end)) >= 2 && line.charAt(start) == '\"' && line.charAt(end - 1) == '\"') {
                start = CharSequences.skipLeadingWhitespaces((CharSequence)line, (int)(start + 1), (int)(--end));
                end = CharSequences.skipTrailingWhitespaces((CharSequence)line, (int)start, (int)end);
            }
            String value = line.substring(start, end);
            try {
                if (this.group == null || !this.group.endsWith(LINEAGE_SUFFIX)) {
                    this.parseKeyValuePair(key, band, value);
                    continue;
                }
                if (!this.group.equals(this.lineageGroup)) {
                    this.lineageGroup = this.group;
                    this.newLineage();
                }
                this.parseLineage(key, band, value);
            }
            catch (IllegalArgumentException | DateTimeException e) {
                this.warning(key, reader, e);
            }
        }
        this.listeners.warning(this.errors().getString((short)168, (Object)this.getFilename()));
    }

    private Double parseDouble(String value) throws NumberFormatException {
        return this.shared(Double.parseDouble(value));
    }

    private void parseCorner(int index, String value) throws NumberFormatException {
        this.corners[index] = Double.parseDouble(value);
    }

    private void parseGridSize(BandGroupName group, boolean isX, String value) throws NumberFormatException {
        int s = Integer.parseUnsignedInt(value);
        Dimension size = this.gridSizes.computeIfAbsent(group, k -> new Dimension());
        if (isX) {
            size.width = s;
        } else {
            size.height = s;
        }
    }

    private void parseKeyValuePair(String key, int band, String value) throws IllegalArgumentException, DateTimeException, DataStoreException {
        switch (key) {
            case "GROUP": {
                this.group = value;
                break;
            }
            case "END_GROUP": {
                this.group = null;
                break;
            }
            case "ORIGIN": {
                Matcher m = CREDIT.matcher(value);
                if (m.find()) {
                    this.newParty(MetadataBuilder.PartyType.ORGANISATION);
                    this.addAuthor(value.substring(m.end()));
                }
                this.addCredits(value);
                break;
            }
            case "REQUEST_ID": {
                this.addAcquisitionRequirement(null, value);
                break;
            }
            case "LANDSAT_PRODUCT_ID": 
            case "LANDSAT_SCENE_ID": {
                this.addTitleOrIdentifier(value, MetadataBuilder.Scope.ALL);
                break;
            }
            case "FILE_DATE": {
                this.addCitationDate(OffsetDateTime.parse(value), DateType.CREATION, MetadataBuilder.Scope.ALL);
                break;
            }
            case "PROCESSING_LEVEL": 
            case "DATA_TYPE": {
                this.setProcessingLevelCode("Landsat", value);
                break;
            }
            case "ELEVATION_SOURCE": {
                this.addSource(value, ScopeCode.MODEL, (CharSequence)Vocabulary.formatInternational((short)63));
                break;
            }
            case "OUTPUT_FORMAT": {
                if ("GeoTIFF".equalsIgnoreCase(value)) {
                    this.setPredefinedFormat("GeoTIFF", this.listeners, true);
                    break;
                }
                this.addFormatName(value);
                break;
            }
            case "SPACECRAFT_ID": {
                this.addPlatform(null, value);
                break;
            }
            case "SENSOR_ID": {
                this.addInstrument(null, value);
                break;
            }
            case "DATE_ACQUIRED": {
                LocalDate date = LocalDate.parse(value);
                if (this.sceneTime instanceof OffsetTime) {
                    this.sceneTime = date.atTime((OffsetTime)this.sceneTime);
                    break;
                }
                if (date.equals(this.sceneTime)) break;
                this.flushSceneTime();
                this.sceneTime = date;
                break;
            }
            case "SCENE_CENTER_TIME": {
                OffsetTime time = OffsetTime.parse(value);
                if (this.sceneTime instanceof LocalDate) {
                    this.sceneTime = ((LocalDate)this.sceneTime).atTime(time);
                    break;
                }
                this.sceneTime = time;
                break;
            }
            case "CORNER_UL_LON_PRODUCT": {
                this.parseCorner(8, value);
                break;
            }
            case "CORNER_UL_LAT_PRODUCT": {
                this.parseCorner(9, value);
                break;
            }
            case "CORNER_UR_LON_PRODUCT": {
                this.parseCorner(10, value);
                break;
            }
            case "CORNER_UR_LAT_PRODUCT": {
                this.parseCorner(11, value);
                break;
            }
            case "CORNER_LL_LON_PRODUCT": {
                this.parseCorner(12, value);
                break;
            }
            case "CORNER_LL_LAT_PRODUCT": {
                this.parseCorner(13, value);
                break;
            }
            case "CORNER_LR_LON_PRODUCT": {
                this.parseCorner(14, value);
                break;
            }
            case "CORNER_LR_LAT_PRODUCT": {
                this.parseCorner(15, value);
                break;
            }
            case "CORNER_UL_PROJECTION_X_PRODUCT": {
                this.parseCorner(0, value);
                break;
            }
            case "CORNER_UL_PROJECTION_Y_PRODUCT": {
                this.parseCorner(1, value);
                break;
            }
            case "CORNER_UR_PROJECTION_X_PRODUCT": {
                this.parseCorner(2, value);
                break;
            }
            case "CORNER_UR_PROJECTION_Y_PRODUCT": {
                this.parseCorner(3, value);
                break;
            }
            case "CORNER_LL_PROJECTION_X_PRODUCT": {
                this.parseCorner(4, value);
                break;
            }
            case "CORNER_LL_PROJECTION_Y_PRODUCT": {
                this.parseCorner(5, value);
                break;
            }
            case "CORNER_LR_PROJECTION_X_PRODUCT": {
                this.parseCorner(6, value);
                break;
            }
            case "CORNER_LR_PROJECTION_Y_PRODUCT": {
                this.parseCorner(7, value);
                break;
            }
            case "PANCHROMATIC_LINES": {
                this.parseGridSize(BandGroupName.PANCHROMATIC, false, value);
                break;
            }
            case "PANCHROMATIC_SAMPLES": {
                this.parseGridSize(BandGroupName.PANCHROMATIC, true, value);
                break;
            }
            case "REFLECTIVE_LINES": {
                this.parseGridSize(BandGroupName.REFLECTIVE, false, value);
                break;
            }
            case "REFLECTIVE_SAMPLES": {
                this.parseGridSize(BandGroupName.REFLECTIVE, true, value);
                break;
            }
            case "THERMAL_LINES": {
                this.parseGridSize(BandGroupName.THERMAL, false, value);
                break;
            }
            case "THERMAL_SAMPLES": {
                this.parseGridSize(BandGroupName.THERMAL, true, value);
                break;
            }
            case "GRID_CELL_SIZE_PANCHROMATIC": 
            case "GRID_CELL_SIZE_REFLECTIVE": 
            case "GRID_CELL_SIZE_THERMAL": {
                this.addLinearResolution(Double.parseDouble(value));
                break;
            }
            case "FILE_NAME_BAND_": {
                this.band(key, band).ifPresent(b -> {
                    b.filename = value;
                });
                break;
            }
            case "DATA_TYPE_BAND_": {
                int s = value.lastIndexOf("INT");
                if (s < 0) break;
                try {
                    Integer n = Integer.valueOf(value.substring(s + 3));
                    this.sampleDimension(key, band).ifPresent(sd -> sd.setBitsPerValue(n));
                }
                catch (NumberFormatException e) {
                    this.warning(key, null, e);
                }
                break;
            }
            case "METADATA_FILE_NAME": {
                if (this.filename != null) break;
                this.filename = value;
                break;
            }
            case "CLOUD_COVER": {
                double v = Double.parseDouble(value);
                if (!(v >= 0.0)) break;
                this.setCloudCoverPercentage(v);
                break;
            }
            case "SUN_AZIMUTH": {
                this.setIlluminationAzimuthAngle(Double.parseDouble(value));
                break;
            }
            case "SUN_ELEVATION": {
                this.setIlluminationElevationAngle(Double.parseDouble(value));
                break;
            }
            case "QUANTIZE_CAL_MIN_BAND_": {
                Double v = this.parseDouble(value);
                this.sampleDimension(key, band).ifPresent(sd -> sd.setMinValue(v));
                break;
            }
            case "QUANTIZE_CAL_MAX_BAND_": {
                Double v = this.parseDouble(value);
                this.sampleDimension(key, band).ifPresent(sd -> sd.setMaxValue(v));
                break;
            }
            case "RADIANCE_MULT_BAND_": {
                this.setTransferFunction(key, band, false, true, value);
                break;
            }
            case "REFLECTANCE_MULT_BAND_": {
                this.setTransferFunction(key, band, true, true, value);
                break;
            }
            case "RADIANCE_ADD_BAND_": {
                this.setTransferFunction(key, band, false, false, value);
                break;
            }
            case "REFLECTANCE_ADD_BAND_": {
                this.setTransferFunction(key, band, true, false, value);
                break;
            }
            case "MAP_PROJECTION": {
                if ("UTM".equalsIgnoreCase(value)) {
                    this.projection = null;
                    break;
                }
                if (!"PS".equalsIgnoreCase(value)) break;
                try {
                    this.projection = CoordinateOperations.builder((MathTransformFactory)this.factories.getMathTransformFactory(), (String)"EPSG:9829");
                    this.utmZone = (short)-1;
                    break;
                }
                catch (NoSuchIdentifierException e) {
                    throw new DataStoreReferencingException(e.getMessage(), (Throwable)e);
                }
            }
            case "DATUM": {
                this.datum = CommonCRS.valueOf((String)Strings.toUpperCase((String)value, (Characters.Filter)Characters.Filter.LETTERS_AND_DIGITS, (boolean)true));
                break;
            }
            case "UTM_ZONE": {
                if (this.utmZone != 0) break;
                this.utmZone = Short.parseShort(value);
                break;
            }
            case "VERTICAL_LON_FROM_POLE": {
                this.setProjectionParameter(key, "central_meridian", value, false);
                break;
            }
            case "TRUE_SCALE_LAT": {
                this.setProjectionParameter(key, "standard_parallel_1", value, false);
                break;
            }
            case "FALSE_EASTING": {
                this.setProjectionParameter(key, "false_easting", value, true);
                break;
            }
            case "FALSE_NORTHING": {
                this.setProjectionParameter(key, "false_northing", value, true);
            }
        }
    }

    private void parseLineage(String key, int band, String value) {
        switch (key) {
            case "GROUP": {
                this.group = value;
                break;
            }
            case "END_GROUP": {
                this.group = null;
                break;
            }
            case "LANDSAT_PRODUCT_ID": {
                this.addSource(value, null, null);
                break;
            }
            case "PROCESSING_LEVEL": {
                this.addProcessing(null, value);
                break;
            }
            case "PROCESSING_SOFTWARE_VERSION": {
                this.addSoftwareReference(value);
            }
        }
    }

    private void setTransferFunction(String key, int band, boolean reflectance, boolean isScale, String value) {
        Double v = this.parseDouble(value);
        this.band(key, band).ifPresent(b -> {
            if (b.band.group.reflectance == reflectance) {
                DefaultSampleDimension sd = b.sampleDimension;
                sd.setTransferFunctionType(TransferFunctionType.LINEAR);
                if (isScale) {
                    sd.setScaleFactor(v);
                } else {
                    sd.setOffset(v);
                }
            }
        });
    }

    private Optional<Band> band(String key, int index) {
        if (index < 1 || index > this.bandEnumerations.length) {
            this.listeners.warning(this.errors().getString((short)176, (Object)(key + index), (Object)index));
            return Optional.empty();
        }
        BandName band = this.bandEnumerations[index - 1];
        Band data = this.bands.get((Object)band);
        if (data == null) {
            data = new Band(this.store, band);
            this.bands.put(band, data);
        }
        return Optional.of(data);
    }

    private Optional<DefaultSampleDimension> sampleDimension(String key, int index) {
        return this.band(key, index).map(band -> band.sampleDimension);
    }

    private void setProjectionParameter(String key, String name, String value, boolean isLinear) {
        if (this.projection != null) {
            this.projection.parameters().parameter(name).setValue(Double.parseDouble(value), isLinear ? Units.METRE : Units.DEGREE);
        } else {
            this.listeners.warning(this.errors().getString((short)173, (Object)this.filename, (Object)key));
        }
    }

    private void flushSceneTime() {
        Temporal st = this.sceneTime;
        if (st != null) {
            this.sceneTime = null;
            this.addAcquisitionTime(st);
            this.addTemporalExtent(st, st);
        }
    }

    private boolean toBoundingBox(int base) {
        double xmin = Double.POSITIVE_INFINITY;
        double ymin = Double.POSITIVE_INFINITY;
        double xmax = Double.NEGATIVE_INFINITY;
        double ymax = Double.NEGATIVE_INFINITY;
        int i = base + 8;
        while (--i >= base) {
            double v = this.corners[i];
            if (v < ymin) {
                ymin = v;
            }
            if (v > ymax) {
                ymax = v;
            }
            if ((v = this.corners[--i]) < xmin) {
                xmin = v;
            }
            if (!(v > xmax)) continue;
            xmax = v;
        }
        if (xmin < xmax && ymin < ymax) {
            this.corners[base] = xmin;
            this.corners[++base] = xmax;
            this.corners[++base] = ymin;
            this.corners[++base] = ymax;
            return true;
        }
        return false;
    }

    final Metadata getMetadata() throws FactoryException {
        this.addLanguage(Locale.ENGLISH, StandardCharsets.US_ASCII, MetadataBuilder.Scope.METADATA);
        this.addResourceScope(ScopeCode.valueOf((String)"COVERAGE"), null);
        this.addTopicCategory(TopicCategory.GEOSCIENTIFIC_INFORMATION);
        try {
            this.flushSceneTime();
        }
        catch (DateTimeException e) {
            this.warning(null, null, e);
        }
        if (this.datum != null) {
            if (this.utmZone > 0) {
                this.addReferenceSystem((ReferenceSystem)this.datum.universal(1.0, TransverseMercator.Zoner.UTM.centralMeridian((int)this.utmZone)));
            }
            if (this.projection != null) {
                ParameterValueGroup p = this.projection.parameters();
                double sp = p.parameter("standard_parallel_1").doubleValue();
                ProjectedCRS crs = (ProjectedCRS)CRS.forCode((String)("EPSG:" + (sp >= 0.0 ? (short)3995 : 3031)));
                if (this.datum != CommonCRS.WGS84 || Math.abs(sp) != 71.0 || p.parameter("false_easting").doubleValue() != 0.0 || p.parameter("false_northing").doubleValue() != 0.0 || p.parameter("central_meridian").doubleValue() != 0.0) {
                    crs = ((GeodeticObjectBuilder)new GeodeticObjectBuilder(this.factories, this.listeners.getLocale()).addName((CharSequence)"Polar stereographic")).setConversion(this.projection).createProjectedCRS(this.datum.geographic(), crs.getCoordinateSystem());
                }
                this.addReferenceSystem((ReferenceSystem)crs);
            }
        }
        if (this.toBoundingBox(8)) {
            this.addExtent(this.corners, 8);
        }
        for (Dimension size : this.gridSizes.values()) {
            if ((size.width | size.height) == 0) continue;
            this.newGridRepresentation(MetadataBuilder.GridType.GEORECTIFIED);
            this.setAxisName(0, DimensionNameType.SAMPLE);
            this.setAxisName(1, DimensionNameType.LINE);
            this.setAxisSize(0, Integer.toUnsignedLong(size.width));
            this.setAxisSize(1, Integer.toUnsignedLong(size.height));
        }
        this.setISOStandards(true);
        DefaultMetadata result = this.build();
        DefaultCoverageDescription content = (DefaultCoverageDescription)Containers.peekIfSingleton((Iterable)result.getContentInfo());
        if (content != null) {
            EnumMap<BandGroupName, DefaultAttributeGroup> groups = new EnumMap<BandGroupName, DefaultAttributeGroup>(BandGroupName.class);
            for (Map.Entry<BandName, Band> entry : this.bands.entrySet()) {
                DefaultAttributeGroup g = groups.computeIfAbsent(entry.getKey().group, k -> {
                    DefaultAttributeGroup ag = new DefaultAttributeGroup(CoverageContentType.PHYSICAL_MEASUREMENT, null);
                    content.getAttributeGroups().add(ag);
                    return ag;
                });
                g.getAttributes().add(entry.getValue().sampleDimension);
            }
        }
        result.transitionTo(ModifiableMetadata.State.FINAL);
        return result;
    }

    private String getFilename() {
        return this.filename != null ? this.filename : Vocabulary.forLocale((Locale)this.listeners.getLocale()).getString((short)208);
    }

    private String toLongName(String key) {
        if (this.group != null) {
            key = this.group + ":" + (String)key;
        }
        return key;
    }

    private void warning(String key, BufferedReader reader, Exception e) {
        if (key != null) {
            Object file = this.getFilename();
            if (reader instanceof LineNumberReader) {
                file = (String)file + ":" + ((LineNumberReader)reader).getLineNumber();
            }
            key = this.errors().getString((short)18, (Object)this.toLongName(key), file);
        }
        this.listeners.warning(key, e);
    }

    private Errors errors() {
        return Errors.forLocale((Locale)this.listeners.getLocale());
    }
}

