/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.event;

import java.util.EventObject;
import java.util.Locale;
import org.apache.sis.storage.DataStore;
import org.apache.sis.storage.Resource;
import org.apache.sis.storage.base.StoreResource;
import org.apache.sis.util.Localized;

public abstract class StoreEvent
extends EventObject
implements Localized {
    private static final long serialVersionUID = -1725093072445990248L;
    private boolean consumed;
    private boolean consumeLater;

    protected StoreEvent(Resource source) {
        super(source);
    }

    @Override
    public Resource getSource() {
        return (Resource)super.getSource();
    }

    public Locale getLocale() {
        DataStore ds;
        Locale locale;
        if (this.source instanceof Localized && (locale = ((Localized)this.source).getLocale()) != null) {
            return locale;
        }
        if (this.source instanceof StoreResource && (ds = ((StoreResource)this.source).getOriginator()) != null) {
            return ds.getLocale();
        }
        return null;
    }

    public final boolean isConsumed() {
        return this.consumed;
    }

    final boolean isConsumedForParent() {
        return this.consumed |= this.consumeLater;
    }

    public void consume(boolean later) {
        if (later) {
            this.consumeLater = true;
        } else {
            this.consumed = true;
        }
    }
}

