/*
 * Decompiled with CFR 0.152.
 */
package org.sparkproject.jpmml.model.collections;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.RandomAccess;
import org.sparkproject.jpmml.model.collections.AbstractFixedSizeList;

public class SingletonList<E>
extends AbstractFixedSizeList<E>
implements RandomAccess,
Serializable {
    private E element = null;

    public SingletonList(E element) {
        this.element = element;
    }

    @Override
    public int size() {
        return 1;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public boolean equals(Object object) {
        List that;
        if (object instanceof List && (that = (List)object).size() == 1) {
            return Objects.equals(this.element, that.get(0));
        }
        return false;
    }

    @Override
    public E get(int index) {
        switch (index) {
            case 0: {
                return this.element;
            }
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public E set(int index, E element) {
        switch (index) {
            case 0: {
                E result = this.element;
                this.element = element;
                return result;
            }
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public List<E> subList(int fromIndex, int toIndex) {
        if (fromIndex < 0 || toIndex > 1) {
            throw new IndexOutOfBoundsException();
        }
        int length = toIndex - fromIndex;
        switch (length) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return this;
            }
        }
        throw new IllegalArgumentException();
    }
}

