/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import org.apache.spark.sql.catalyst.analysis.ExpressionBuilder;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ToTime;
import org.apache.spark.sql.catalyst.expressions.TryEval;
import org.apache.spark.sql.catalyst.plans.logical.FunctionBuilderBase;
import org.apache.spark.sql.catalyst.plans.logical.FunctionSignature;
import org.apache.spark.sql.errors.QueryCompilationErrors$;
import scala.Function2;
import scala.Option;
import scala.collection.IterableOps;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="\n    _FUNC_(str[, format]) - Parses the `str` expression with the `format` expression to a time.\n    If `format` is malformed or its application does not result in a well formed time, the function\n    returns NULL. By default, it follows casting rules to a time if the `format` is omitted.\n  ", arguments="\n    Arguments:\n      * str - A string to be parsed to time.\n      * format - Time format pattern to follow. See <a href=\"https://spark.apache.org/docs/latest/sql-ref-datetime-pattern.html\">Datetime Patterns</a> for valid\n                 time format patterns.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_('00:12:00.001');\n       00:12:00.001\n      > SELECT _FUNC_('12.10.05.999999', 'HH.mm.ss.SSSSSS');\n       12:10:05.999999\n      > SELECT _FUNC_('foo', 'HH:mm:ss');\n       NULL\n  ", group="datetime_funcs", since="4.1.0")
public final class TryToTimeExpressionBuilder$
implements ExpressionBuilder {
    public static final TryToTimeExpressionBuilder$ MODULE$ = new TryToTimeExpressionBuilder$();

    static {
        FunctionBuilderBase.$init$(MODULE$);
    }

    @Override
    public Option<FunctionSignature> functionSignature() {
        return FunctionBuilderBase.functionSignature$(this);
    }

    @Override
    public Seq<Expression> rearrange(FunctionSignature expectedSignature, Seq<Expression> providedArguments, String functionName, Function2<String, String, Object> resolver) {
        return FunctionBuilderBase.rearrange$(this, expectedSignature, providedArguments, functionName, resolver);
    }

    @Override
    public boolean supportsLambda() {
        return FunctionBuilderBase.supportsLambda$(this);
    }

    @Override
    public Expression build(String funcName, Seq<Expression> expressions) {
        int numArgs = expressions.length();
        if (numArgs == 1 || numArgs == 2) {
            return new TryEval(new ToTime((Expression)expressions.head(), (Option<Expression>)((IterableOps)expressions.drop(1)).lastOption()));
        }
        throw QueryCompilationErrors$.MODULE$.wrongNumArgsError(funcName, (Seq<Object>)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2}))), numArgs, QueryCompilationErrors$.MODULE$.wrongNumArgsError$default$4(), QueryCompilationErrors$.MODULE$.wrongNumArgsError$default$5(), QueryCompilationErrors$.MODULE$.wrongNumArgsError$default$6());
    }

    private TryToTimeExpressionBuilder$() {
    }
}

