/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.runtime.library.processor;

import java.util.List;
import java.util.Map;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.tez.common.ProgressHelper;
import org.apache.tez.runtime.api.AbstractLogicalIOProcessor;
import org.apache.tez.runtime.api.Event;
import org.apache.tez.runtime.api.LogicalInput;
import org.apache.tez.runtime.api.LogicalOutput;
import org.apache.tez.runtime.api.ProcessorContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public abstract class SimpleProcessor
extends AbstractLogicalIOProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractLogicalIOProcessor.class);
    protected Map<String, LogicalInput> inputs;
    protected Map<String, LogicalOutput> outputs;
    protected ProgressHelper progressHelper;

    public SimpleProcessor(ProcessorContext context) {
        super(context);
    }

    public void run(Map<String, LogicalInput> _inputs, Map<String, LogicalOutput> _outputs) throws Exception {
        this.inputs = _inputs;
        this.outputs = _outputs;
        this.progressHelper = new ProgressHelper(this.inputs, this.getContext(), ((Object)((Object)this)).getClass().getSimpleName());
        this.preOp();
        this.run();
        this.postOp();
    }

    public abstract void run() throws Exception;

    protected void preOp() throws Exception {
        if (this.getInputs() != null) {
            for (LogicalInput input : this.getInputs().values()) {
                input.start();
            }
            this.progressHelper.scheduleProgressTaskService(0L, 100L);
        }
        if (this.getOutputs() != null) {
            for (LogicalOutput output : this.getOutputs().values()) {
                output.start();
            }
        }
    }

    protected void postOp() throws Exception {
    }

    public void initialize() throws Exception {
    }

    public void handleEvents(List<Event> processorEvents) {
    }

    public void close() throws Exception {
        if (this.progressHelper != null) {
            this.progressHelper.shutDownProgressTaskService();
        }
    }

    public Map<String, LogicalInput> getInputs() {
        return this.inputs;
    }

    public Map<String, LogicalOutput> getOutputs() {
        return this.outputs;
    }
}

