/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.autoconfigure.internal;

import io.opentelemetry.sdk.autoconfigure.internal.NamedSpiManager;
import io.opentelemetry.sdk.autoconfigure.spi.ConfigProperties;
import io.opentelemetry.sdk.autoconfigure.spi.Ordered;
import io.opentelemetry.sdk.autoconfigure.spi.internal.AutoConfigureListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;

public final class SpiHelper {
    private final ClassLoader classLoader;
    private final SpiFinder spiFinder;
    private final Set<AutoConfigureListener> listeners = Collections.newSetFromMap(new IdentityHashMap());

    SpiHelper(ClassLoader classLoader, SpiFinder spiFinder) {
        this.classLoader = classLoader;
        this.spiFinder = spiFinder;
    }

    public static SpiHelper create(ClassLoader classLoader) {
        return new SpiHelper(classLoader, ServiceLoader::load);
    }

    public <T, S> NamedSpiManager<T> loadConfigurable(Class<S> spiClass, Function<S, String> getName, BiFunction<S, ConfigProperties, T> getConfigurable, ConfigProperties config) {
        HashMap nameToProvider = new HashMap();
        for (Object provider : this.load(spiClass)) {
            String name = getName.apply(provider);
            nameToProvider.put(name, () -> {
                Object result = getConfigurable.apply(provider, config);
                this.maybeAddListener(result);
                return result;
            });
        }
        return NamedSpiManager.create(nameToProvider);
    }

    public <T extends Ordered> List<T> loadOrdered(Class<T> spiClass) {
        List<T> result = this.load(spiClass);
        result.sort(Comparator.comparing(Ordered::order));
        return result;
    }

    public <T> List<T> load(Class<T> spiClass) {
        ArrayList<T> result = new ArrayList<T>();
        for (T service : this.spiFinder.load(spiClass, this.classLoader)) {
            this.maybeAddListener(service);
            result.add(service);
        }
        return result;
    }

    private void maybeAddListener(Object object) {
        if (object instanceof AutoConfigureListener) {
            this.listeners.add((AutoConfigureListener)object);
        }
    }

    public Set<AutoConfigureListener> getListeners() {
        return Collections.unmodifiableSet(this.listeners);
    }

    static interface SpiFinder {
        public <T> Iterable<T> load(Class<T> var1, ClassLoader var2);
    }
}

