/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.recording;

import com.github.tomakehurst.wiremock.common.ContentTypes;
import com.github.tomakehurst.wiremock.http.Request;
import com.github.tomakehurst.wiremock.matching.AnythingPattern;
import com.github.tomakehurst.wiremock.matching.BinaryEqualToPattern;
import com.github.tomakehurst.wiremock.matching.ContentPattern;
import com.github.tomakehurst.wiremock.matching.EqualToJsonPattern;
import com.github.tomakehurst.wiremock.matching.EqualToPattern;
import com.github.tomakehurst.wiremock.matching.EqualToXmlPattern;
import com.github.tomakehurst.wiremock.recording.RequestBodyPatternFactory;
import wiremock.com.fasterxml.jackson.annotation.JsonCreator;
import wiremock.com.fasterxml.jackson.annotation.JsonProperty;

public class RequestBodyAutomaticPatternFactory
implements RequestBodyPatternFactory {
    private final Boolean caseInsensitive;
    private final Boolean ignoreArrayOrder;
    private final Boolean ignoreExtraElements;
    public static final RequestBodyAutomaticPatternFactory DEFAULTS = new RequestBodyAutomaticPatternFactory();

    @JsonCreator
    public RequestBodyAutomaticPatternFactory(@JsonProperty(value="ignoreArrayOrder") Boolean ignoreArrayOrder, @JsonProperty(value="ignoreExtraElements") Boolean ignoreExtraElements, @JsonProperty(value="caseInsensitive") Boolean caseInsensitive) {
        this.ignoreArrayOrder = ignoreArrayOrder == null ? true : ignoreArrayOrder;
        this.ignoreExtraElements = ignoreExtraElements == null ? true : ignoreExtraElements;
        this.caseInsensitive = caseInsensitive == null ? false : caseInsensitive;
    }

    private RequestBodyAutomaticPatternFactory() {
        this(null, null, null);
    }

    public Boolean isIgnoreArrayOrder() {
        return this.ignoreArrayOrder;
    }

    public Boolean isIgnoreExtraElements() {
        return this.ignoreExtraElements;
    }

    public Boolean isCaseInsensitive() {
        return this.caseInsensitive;
    }

    @Override
    public ContentPattern<?> forRequest(Request request) {
        String mimeType = request.getHeaders().getContentTypeHeader().mimeTypePart();
        if (mimeType != null) {
            if (mimeType.contains("json")) {
                return new EqualToJsonPattern(request.getBodyAsString(), this.ignoreArrayOrder, this.ignoreExtraElements);
            }
            if (mimeType.contains("xml")) {
                return new EqualToXmlPattern(request.getBodyAsString());
            }
            if (mimeType.equals("multipart/form-data")) {
                return new AnythingPattern();
            }
            if (!ContentTypes.determineIsTextFromMimeType(mimeType)) {
                return new BinaryEqualToPattern(request.getBody());
            }
        }
        return new EqualToPattern(request.getBodyAsString(), this.caseInsensitive);
    }
}

